/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkSslEngine;
import io.grpc.netty.shaded.io.netty.handler.ssl.JettyAlpnSslEngine$1;
import io.grpc.netty.shaded.io.netty.handler.ssl.JettyAlpnSslEngine$ClientEngine;
import io.grpc.netty.shaded.io.netty.handler.ssl.JettyAlpnSslEngine$ServerEngine;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import javax.net.ssl.SSLEngine;

abstract class JettyAlpnSslEngine
extends JdkSslEngine {
    private static final boolean available = JettyAlpnSslEngine.initAvailable();

    static boolean isAvailable() {
        return available;
    }

    private static boolean initAvailable() {
        if (PlatformDependent.javaVersion() <= 8) {
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    static JettyAlpnSslEngine newClientEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new JettyAlpnSslEngine$ClientEngine(sSLEngine, jdkApplicationProtocolNegotiator);
    }

    static JettyAlpnSslEngine newServerEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new JettyAlpnSslEngine$ServerEngine(sSLEngine, jdkApplicationProtocolNegotiator);
    }

    private JettyAlpnSslEngine(SSLEngine sSLEngine) {
        super(sSLEngine);
    }

    /* synthetic */ JettyAlpnSslEngine(SSLEngine sSLEngine, JettyAlpnSslEngine$1 jettyAlpnSslEngine$1) {
        this(sSLEngine);
    }
}

