/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$AllocatorAwareSslEngineWrapperFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$SslEngineWrapperFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkDefaultApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;

public class JdkSslContext
extends SslContext {
    private static final InternalLogger logger;
    static final String PROTOCOL = "TLS";
    private static final String[] DEFAULT_PROTOCOLS;
    private static final List<String> DEFAULT_CIPHERS;
    private static final List<String> DEFAULT_CIPHERS_NON_TLSV13;
    private static final Set<String> SUPPORTED_CIPHERS;
    private static final Set<String> SUPPORTED_CIPHERS_NON_TLSV13;
    private static final Provider DEFAULT_PROVIDER;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;
    private final JdkApplicationProtocolNegotiator apn;
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final boolean isClient;

    private static String[] defaultProtocols(SSLEngine sSLEngine) {
        String[] stringArray = sSLEngine.getSupportedProtocols();
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(hashSet, arrayList, "TLSv1.2", "TLSv1.1", "TLSv1");
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new String[0]);
        }
        return sSLEngine.getEnabledProtocols();
    }

    private static Set<String> supportedCiphers(SSLEngine sSLEngine) {
        String[] stringArray = sSLEngine.getSupportedCipherSuites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string = stringArray[i3];
            linkedHashSet.add(string);
            if (!string.startsWith("SSL_")) continue;
            String string2 = "TLS_" + string.substring("SSL_".length());
            try {
                sSLEngine.setEnabledCipherSuites(new String[]{string2});
                linkedHashSet.add(string2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return linkedHashSet;
    }

    private static List<String> defaultCiphers(SSLEngine sSLEngine, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(set, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, sSLEngine.getEnabledCipherSuites());
        return arrayList;
    }

    private static boolean isTlsV13Supported(String[] stringArray) {
        for (String string : stringArray) {
            if (!"TLSv1.3".equals(string)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public JdkSslContext(SSLContext sSLContext, boolean bl3, ClientAuth clientAuth) {
        this(sSLContext, bl3, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, JdkDefaultApplicationProtocolNegotiator.INSTANCE, clientAuth, null, false);
    }

    @Deprecated
    public JdkSslContext(SSLContext sSLContext, boolean bl3, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth) {
        this(sSLContext, bl3, iterable, cipherSuiteFilter, applicationProtocolConfig, clientAuth, null, false);
    }

    public JdkSslContext(SSLContext sSLContext, boolean bl3, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth, String[] stringArray, boolean bl4) {
        this(sSLContext, bl3, iterable, cipherSuiteFilter, JdkSslContext.toNegotiator(applicationProtocolConfig, !bl3), clientAuth, stringArray == null ? null : (String[])stringArray.clone(), bl4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdkSslContext(SSLContext sSLContext, boolean bl3, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, ClientAuth clientAuth, String[] stringArray, boolean bl4) {
        super(bl4);
        List<String> list;
        Set<String> set;
        this.apn = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator, "apn");
        this.clientAuth = ObjectUtil.checkNotNull(clientAuth, "clientAuth");
        this.sslContext = ObjectUtil.checkNotNull(sSLContext, "sslContext");
        if (DEFAULT_PROVIDER.equals(sSLContext.getProvider())) {
            String[] stringArray2 = this.protocols = stringArray == null ? DEFAULT_PROTOCOLS : stringArray;
            if (JdkSslContext.isTlsV13Supported(this.protocols)) {
                set = SUPPORTED_CIPHERS;
                list = DEFAULT_CIPHERS;
            } else {
                set = SUPPORTED_CIPHERS_NON_TLSV13;
                list = DEFAULT_CIPHERS_NON_TLSV13;
            }
        } else {
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            try {
                this.protocols = stringArray == null ? JdkSslContext.defaultProtocols(sSLEngine) : stringArray;
                set = JdkSslContext.supportedCiphers(sSLEngine);
                list = JdkSslContext.defaultCiphers(sSLEngine, set);
                if (!JdkSslContext.isTlsV13Supported(this.protocols)) {
                    for (String string : SslUtils.DEFAULT_TLSV13_CIPHER_SUITES) {
                        set.remove(string);
                        list.remove(string);
                    }
                }
            }
            finally {
                ReferenceCountUtil.release(sSLEngine);
            }
        }
        this.cipherSuites = ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, list, set);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
        this.isClient = bl3;
    }

    public final SSLContext context() {
        return this.sslContext;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final SSLSessionContext sessionContext() {
        if (this.isServer()) {
            return this.context().getServerSessionContext();
        }
        return this.context().getClientSessionContext();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCipherSuites;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionContext().getSessionCacheSize();
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionContext().getSessionTimeout();
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.configureAndWrapEngine(this.context().createSSLEngine(), byteBufAllocator);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n4) {
        return this.configureAndWrapEngine(this.context().createSSLEngine(string, n4), byteBufAllocator);
    }

    private SSLEngine configureAndWrapEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator) {
        JdkApplicationProtocolNegotiator$SslEngineWrapperFactory jdkApplicationProtocolNegotiator$SslEngineWrapperFactory;
        sSLEngine.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine.setEnabledProtocols(this.protocols);
        sSLEngine.setUseClientMode(this.isClient());
        if (this.isServer()) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    sSLEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sSLEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                }
            }
        }
        if ((jdkApplicationProtocolNegotiator$SslEngineWrapperFactory = this.apn.wrapperFactory()) instanceof JdkApplicationProtocolNegotiator$AllocatorAwareSslEngineWrapperFactory) {
            return ((JdkApplicationProtocolNegotiator$AllocatorAwareSslEngineWrapperFactory)jdkApplicationProtocolNegotiator$SslEngineWrapperFactory).wrapSslEngine(sSLEngine, byteBufAllocator, this.apn, this.isServer());
        }
        return jdkApplicationProtocolNegotiator$SslEngineWrapperFactory.wrapSslEngine(sSLEngine, this.apn, this.isServer());
    }

    @Override
    public final JdkApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig, boolean bl3) {
        if (applicationProtocolConfig == null) {
            return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (bl3) {
                    switch (applicationProtocolConfig.selectorFailureBehavior()) {
                        case FATAL_ALERT: {
                            return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                        case NO_ADVERTISE: {
                            return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
            }
            case NPN: {
                if (bl3) {
                    switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                        case ACCEPT: {
                            return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                        case FATAL_ALERT: {
                            return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectorFailureBehavior()) {
                    case FATAL_ALERT: {
                        return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                    case NO_ADVERTISE: {
                        return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.protocol()) + " protocol");
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory, String string2) {
        String string3 = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (string3 == null) {
            string3 = "SunX509";
        }
        return JdkSslContext.buildKeyManagerFactory(file, string3, file2, string, keyManagerFactory, string2);
    }

    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory) {
        return JdkSslContext.buildKeyManagerFactory(file, file2, string, keyManagerFactory, KeyStore.getDefaultType());
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory, String string3) {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, string3);
    }

    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory) {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, KeyStore.getDefaultType());
    }

    static {
        SSLContext sSLContext;
        logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
        try {
            sSLContext = SSLContext.getInstance(PROTOCOL);
            sSLContext.init(null, null, null);
        }
        catch (Exception exception) {
            throw new Error("failed to initialize the default SSL context", exception);
        }
        DEFAULT_PROVIDER = sSLContext.getProvider();
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        DEFAULT_PROTOCOLS = JdkSslContext.defaultProtocols(sSLEngine);
        SUPPORTED_CIPHERS = Collections.unmodifiableSet(JdkSslContext.supportedCiphers(sSLEngine));
        DEFAULT_CIPHERS = Collections.unmodifiableList(JdkSslContext.defaultCiphers(sSLEngine, SUPPORTED_CIPHERS));
        ArrayList<String> arrayList = new ArrayList<String>(DEFAULT_CIPHERS);
        arrayList.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
        DEFAULT_CIPHERS_NON_TLSV13 = Collections.unmodifiableList(arrayList);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(SUPPORTED_CIPHERS);
        linkedHashSet.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
        SUPPORTED_CIPHERS_NON_TLSV13 = Collections.unmodifiableSet(linkedHashSet);
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): {} ", (Object)Arrays.asList(DEFAULT_PROTOCOLS));
            logger.debug("Default cipher suites (JDK): {}", (Object)DEFAULT_CIPHERS);
        }
    }
}

