/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslUtils$1;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslUtils$2;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslUtils$3;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslUtils$4;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslUtils$5;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslUtils$6;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class Java9SslUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Java9SslUtils.class);
    private static final Method SET_APPLICATION_PROTOCOLS;
    private static final Method GET_APPLICATION_PROTOCOL;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL;
    private static final Method SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;

    private Java9SslUtils() {
    }

    static boolean supportsAlpn() {
        return GET_APPLICATION_PROTOCOL != null;
    }

    static String getApplicationProtocol(SSLEngine sSLEngine) {
        try {
            return (String)GET_APPLICATION_PROTOCOL.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static String getHandshakeApplicationProtocol(SSLEngine sSLEngine) {
        try {
            return (String)GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setApplicationProtocols(SSLEngine sSLEngine, List<String> list) {
        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
        String[] stringArray = list.toArray(EmptyArrays.EMPTY_STRINGS);
        try {
            SET_APPLICATION_PROTOCOLS.invoke((Object)sSLParameters, new Object[]{stringArray});
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        sSLEngine.setSSLParameters(sSLParameters);
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine sSLEngine, BiFunction<SSLEngine, List<String>, String> biFunction) {
        try {
            SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine, biFunction);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine sSLEngine) {
        try {
            return (BiFunction)GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Method method4 = null;
        Method method5 = null;
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, null, null);
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            method = AccessController.doPrivileged(new Java9SslUtils$1());
            method.invoke((Object)sSLEngine, new Object[0]);
            method2 = AccessController.doPrivileged(new Java9SslUtils$2());
            method2.invoke((Object)sSLEngine, new Object[0]);
            method3 = AccessController.doPrivileged(new Java9SslUtils$3());
            method3.invoke((Object)sSLEngine.getSSLParameters(), new Object[]{EmptyArrays.EMPTY_STRINGS});
            method4 = AccessController.doPrivileged(new Java9SslUtils$4());
            method4.invoke((Object)sSLEngine, new Java9SslUtils$5());
            method5 = AccessController.doPrivileged(new Java9SslUtils$6());
            method5.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (Throwable throwable) {
            logger.error("Unable to initialize Java9SslUtils, but the detected javaVersion was: {}", (Object)PlatformDependent.javaVersion(), (Object)throwable);
            method = null;
            method2 = null;
            method3 = null;
            method4 = null;
            method5 = null;
        }
        GET_HANDSHAKE_APPLICATION_PROTOCOL = method;
        GET_APPLICATION_PROTOCOL = method2;
        SET_APPLICATION_PROTOCOLS = method3;
        SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method4;
        GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method5;
    }
}

