/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslEngine$AlpnSelector;
import io.grpc.netty.shaded.io.netty.handler.ssl.Java9SslUtils;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$ProtocolSelectionListener;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkSslEngine;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

final class Java9SslEngine
extends JdkSslEngine {
    private final JdkApplicationProtocolNegotiator$ProtocolSelectionListener selectionListener;
    private final Java9SslEngine$AlpnSelector alpnSelector;

    Java9SslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl3) {
        super(sSLEngine);
        if (bl3) {
            this.selectionListener = null;
            this.alpnSelector = new Java9SslEngine$AlpnSelector(this, jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())));
            Java9SslUtils.setHandshakeApplicationProtocolSelector(sSLEngine, this.alpnSelector);
        } else {
            this.selectionListener = jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols());
            this.alpnSelector = null;
            Java9SslUtils.setApplicationProtocols(sSLEngine, jdkApplicationProtocolNegotiator.protocols());
        }
    }

    private SSLEngineResult verifyProtocolSelection(SSLEngineResult sSLEngineResult) {
        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.alpnSelector == null) {
                try {
                    String string = this.getApplicationProtocol();
                    assert (string != null);
                    if (string.isEmpty()) {
                        this.selectionListener.unsupported();
                    }
                    this.selectionListener.selected(string);
                }
                catch (Throwable throwable) {
                    throw SslUtils.toSSLHandshakeException(throwable);
                }
            } else {
                assert (this.selectionListener == null);
                this.alpnSelector.checkUnsupported();
            }
        }
        return sSLEngineResult;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return this.verifyProtocolSelection(super.wrap(byteBuffer, byteBuffer2));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) {
        return this.verifyProtocolSelection(super.wrap(byteBufferArray, byteBuffer));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n4, int n7, ByteBuffer byteBuffer) {
        return this.verifyProtocolSelection(super.wrap(byteBufferArray, n4, n7, byteBuffer));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBuffer2));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n4, int n7) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray, n4, n7));
    }

    @Override
    void setNegotiatedApplicationProtocol(String string) {
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        String string = this.getApplicationProtocol();
        if (string != null) {
            return string.isEmpty() ? null : string;
        }
        return string;
    }

    @Override
    public String getApplicationProtocol() {
        return Java9SslUtils.getApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return Java9SslUtils.getHandshakeApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> biFunction) {
        Java9SslUtils.setHandshakeApplicationProtocolSelector(this.getWrappedEngine(), biFunction);
    }

    @Override
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return Java9SslUtils.getHandshakeApplicationProtocolSelector(this.getWrappedEngine());
    }
}

