/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslCompletionEvent;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class ApplicationProtocolNegotiationHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ApplicationProtocolNegotiationHandler.class);
    private final String fallbackProtocol;

    protected ApplicationProtocolNegotiationHandler(String string) {
        this.fallbackProtocol = ObjectUtil.checkNotNull(string, "fallbackProtocol");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof SslHandshakeCompletionEvent) {
            Object object2;
            try {
                object2 = (SslHandshakeCompletionEvent)object;
                if (((SslCompletionEvent)object2).isSuccess()) {
                    SslHandler sslHandler = channelHandlerContext.pipeline().get(SslHandler.class);
                    if (sslHandler == null) {
                        throw new IllegalStateException("cannot find a SslHandler in the pipeline (required for application-level protocol negotiation)");
                    }
                    String string = sslHandler.applicationProtocol();
                    this.configurePipeline(channelHandlerContext, string != null ? string : this.fallbackProtocol);
                } else {
                    this.handshakeFailure(channelHandlerContext, ((SslCompletionEvent)object2).cause());
                }
            }
            catch (Throwable throwable) {
                this.exceptionCaught(channelHandlerContext, throwable);
            }
            finally {
                object2 = channelHandlerContext.pipeline();
                if (object2.context(this) != null) {
                    object2.remove(this);
                }
            }
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, String var2);

    protected void handshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.warn("{} TLS handshake failed:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.close();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.warn("{} Failed to select the application-level protocol:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.fireExceptionCaught(throwable);
        channelHandlerContext.close();
    }
}

