/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ssl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.ssl.AbstractSniHandler$1;
import io.grpc.netty.shaded.io.netty.handler.ssl.NotSslRecordException;
import io.grpc.netty.shaded.io.netty.handler.ssl.SniCompletionEvent;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;

public abstract class AbstractSniHandler<T>
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractSniHandler.class);
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!this.suppressRead && !this.handshakeFailed) {
            block15: {
                try {
                    int n4 = byteBuf.readerIndex();
                    int n7 = byteBuf.readableBytes();
                    if (n7 < 5) {
                        return;
                    }
                    short s11 = byteBuf.getUnsignedByte(n4);
                    block2 : switch (s11) {
                        case 20: 
                        case 21: {
                            int n8 = SslUtils.getEncryptedPacketLength(byteBuf, n4);
                            if (n8 == -2) {
                                this.handshakeFailed = true;
                                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(byteBuf));
                                byteBuf.skipBytes(byteBuf.readableBytes());
                                channelHandlerContext.fireUserEventTriggered(new SniCompletionEvent(notSslRecordException));
                                SslUtils.handleHandshakeFailure(channelHandlerContext, notSslRecordException, true);
                                throw notSslRecordException;
                            }
                            if (n8 != -1) break;
                            return;
                        }
                        case 22: {
                            int n10;
                            int n11;
                            short s12 = byteBuf.getUnsignedByte(n4 + 1);
                            if (s12 != 3) break;
                            int n12 = byteBuf.getUnsignedShort(n4 + 3) + 5;
                            if (n7 < n12) {
                                return;
                            }
                            int n13 = n4 + n12;
                            int n14 = n4 + 43;
                            if (n13 - n14 < 6) break;
                            short s13 = byteBuf.getUnsignedByte(n14);
                            int n15 = byteBuf.getUnsignedShort(n14 += s13 + 1);
                            short s14 = byteBuf.getUnsignedByte(n14 += n15 + 2);
                            n14 += s14 + 1;
                            if ((n11 = (n14 += 2) + (n10 = byteBuf.getUnsignedShort(n14))) > n13) break;
                            while (n11 - n14 >= 4) {
                                int n16;
                                int n17 = byteBuf.getUnsignedShort(n14);
                                n14 += 2;
                                if (n11 - (n14 += 2) < (n16 = byteBuf.getUnsignedShort(n14))) break block2;
                                if (n17 == 0) {
                                    int n18;
                                    if (n11 - (n14 += 2) < 3) break block2;
                                    short s15 = byteBuf.getUnsignedByte(n14);
                                    ++n14;
                                    if (s15 != 0) break block15;
                                    if (n11 - (n14 += 2) < (n18 = byteBuf.getUnsignedShort(n14))) break block2;
                                    String string = byteBuf.toString(n14, n18, CharsetUtil.US_ASCII);
                                    try {
                                        this.select(channelHandlerContext, string.toLowerCase(Locale.US));
                                    }
                                    catch (Throwable throwable) {
                                        PlatformDependent.throwException(throwable);
                                    }
                                    return;
                                }
                                n14 += n16;
                            }
                            break;
                        }
                    }
                }
                catch (NotSslRecordException notSslRecordException) {
                    throw notSslRecordException;
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) break block15;
                    logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump(byteBuf), exception);
                }
            }
            this.select(channelHandlerContext, null);
        }
    }

    private void select(ChannelHandlerContext channelHandlerContext, String string) {
        Future<T> future = this.lookup(channelHandlerContext, string);
        if (future.isDone()) {
            this.fireSniCompletionEvent(channelHandlerContext, string, future);
            this.onLookupComplete(channelHandlerContext, string, future);
        } else {
            this.suppressRead = true;
            future.addListener(new AbstractSniHandler$1(this, channelHandlerContext, string));
        }
    }

    private void fireSniCompletionEvent(ChannelHandlerContext channelHandlerContext, String string, Future<T> future) {
        Throwable throwable = future.cause();
        if (throwable == null) {
            channelHandlerContext.fireUserEventTriggered(new SniCompletionEvent(string));
        } else {
            channelHandlerContext.fireUserEventTriggered(new SniCompletionEvent(string, throwable));
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2);

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3);

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            channelHandlerContext.read();
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    static /* synthetic */ boolean access$002(AbstractSniHandler abstractSniHandler, boolean bl3) {
        abstractSniHandler.suppressRead = bl3;
        return abstractSniHandler.suppressRead;
    }

    static /* synthetic */ void access$100(AbstractSniHandler abstractSniHandler, ChannelHandlerContext channelHandlerContext, String string, Future future) {
        abstractSniHandler.fireSniCompletionEvent(channelHandlerContext, string, future);
    }

    static /* synthetic */ boolean access$200(AbstractSniHandler abstractSniHandler) {
        return abstractSniHandler.readPending;
    }

    static /* synthetic */ boolean access$202(AbstractSniHandler abstractSniHandler, boolean bl3) {
        abstractSniHandler.readPending = bl3;
        return abstractSniHandler.readPending;
    }
}

