/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.proxy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.grpc.netty.shaded.io.netty.handler.proxy.HttpProxyHandler$HttpProxyConnectException;
import io.grpc.netty.shaded.io.netty.handler.proxy.ProxyHandler;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class HttpProxyHandler
extends ProxyHandler {
    private static final String PROTOCOL = "http";
    private static final String AUTH_BASIC = "basic";
    private final HttpClientCodec codec = new HttpClientCodec();
    private final String username;
    private final String password;
    private final CharSequence authorization;
    private final HttpHeaders outboundHeaders;
    private final boolean ignoreDefaultPortsInConnectHostHeader;
    private HttpResponseStatus status;
    private HttpHeaders inboundHeaders;

    public HttpProxyHandler(SocketAddress socketAddress) {
        this(socketAddress, null);
    }

    public HttpProxyHandler(SocketAddress socketAddress, HttpHeaders httpHeaders) {
        this(socketAddress, httpHeaders, false);
    }

    public HttpProxyHandler(SocketAddress socketAddress, HttpHeaders httpHeaders, boolean bl3) {
        super(socketAddress);
        this.username = null;
        this.password = null;
        this.authorization = null;
        this.outboundHeaders = httpHeaders;
        this.ignoreDefaultPortsInConnectHostHeader = bl3;
    }

    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2) {
        this(socketAddress, string, string2, null);
    }

    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2, HttpHeaders httpHeaders) {
        this(socketAddress, string, string2, httpHeaders, false);
    }

    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2, HttpHeaders httpHeaders, boolean bl3) {
        super(socketAddress);
        if (string == null) {
            throw new NullPointerException("username");
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        this.username = string;
        this.password = string2;
        ByteBuf byteBuf = Unpooled.copiedBuffer(string + ':' + string2, CharsetUtil.UTF_8);
        ByteBuf byteBuf2 = Base64.encode(byteBuf, false);
        this.authorization = new AsciiString("Basic " + byteBuf2.toString(CharsetUtil.US_ASCII));
        byteBuf.release();
        byteBuf2.release();
        this.outboundHeaders = httpHeaders;
        this.ignoreDefaultPortsInConnectHostHeader = bl3;
    }

    @Override
    public String protocol() {
        return PROTOCOL;
    }

    @Override
    public String authScheme() {
        return this.authorization != null ? AUTH_BASIC : "none";
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    protected void addCodec(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        String string = channelHandlerContext.name();
        channelPipeline.addBefore(string, null, this.codec);
    }

    @Override
    protected void removeEncoder(ChannelHandlerContext channelHandlerContext) {
        this.codec.removeOutboundHandler();
    }

    @Override
    protected void removeDecoder(ChannelHandlerContext channelHandlerContext) {
        this.codec.removeInboundHandler();
    }

    @Override
    protected Object newInitialMessage(ChannelHandlerContext channelHandlerContext) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.destinationAddress();
        String string = HttpUtil.formatHostnameForHttp(inetSocketAddress);
        int n4 = inetSocketAddress.getPort();
        String string2 = string + ":" + n4;
        String string3 = this.ignoreDefaultPortsInConnectHostHeader && (n4 == 80 || n4 == 443) ? string : string2;
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, string2, Unpooled.EMPTY_BUFFER, false);
        defaultFullHttpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)string3);
        if (this.authorization != null) {
            defaultFullHttpRequest.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)this.authorization);
        }
        if (this.outboundHeaders != null) {
            defaultFullHttpRequest.headers().add(this.outboundHeaders);
        }
        return defaultFullHttpRequest;
    }

    @Override
    protected boolean handleResponse(ChannelHandlerContext channelHandlerContext, Object object) {
        boolean bl3;
        if (object instanceof HttpResponse) {
            if (this.status != null) {
                throw new HttpProxyHandler$HttpProxyConnectException(this.exceptionMessage("too many responses"), null);
            }
            HttpResponse httpResponse = (HttpResponse)object;
            this.status = httpResponse.status();
            this.inboundHeaders = httpResponse.headers();
        }
        if (bl3 = object instanceof LastHttpContent) {
            if (this.status == null) {
                throw new HttpProxyHandler$HttpProxyConnectException(this.exceptionMessage("missing response"), this.inboundHeaders);
            }
            if (this.status.code() != 200) {
                throw new HttpProxyHandler$HttpProxyConnectException(this.exceptionMessage("status: " + this.status), this.inboundHeaders);
            }
        }
        return bl3;
    }
}

