/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.ipfilter;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import io.grpc.netty.shaded.io.netty.handler.ipfilter.IpFilterRule;
import io.grpc.netty.shaded.io.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetSocketAddress;

@ChannelHandler$Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... ipFilterRuleArray) {
        if (ipFilterRuleArray == null) {
            throw new NullPointerException("rules");
        }
        this.rules = ipFilterRuleArray;
    }

    @Override
    protected boolean accept(ChannelHandlerContext channelHandlerContext, InetSocketAddress inetSocketAddress) {
        for (IpFilterRule ipFilterRule : this.rules) {
            if (ipFilterRule == null) break;
            if (!ipFilterRule.matches(inetSocketAddress)) continue;
            return ipFilterRule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

