/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.flush;

import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.flush.FlushConsolidationHandler$1;
import java.util.concurrent.Future;

public class FlushConsolidationHandler
extends ChannelDuplexHandler {
    private final int explicitFlushAfterFlushes;
    private final boolean consolidateWhenNoReadInProgress;
    private final Runnable flushTask;
    private int flushPendingCount;
    private boolean readInProgress;
    private ChannelHandlerContext ctx;
    private Future<?> nextScheduledFlush;
    public static final int DEFAULT_EXPLICIT_FLUSH_AFTER_FLUSHES = 256;

    public FlushConsolidationHandler() {
        this(256, false);
    }

    public FlushConsolidationHandler(int n4) {
        this(n4, false);
    }

    public FlushConsolidationHandler(int n4, boolean bl3) {
        if (n4 <= 0) {
            throw new IllegalArgumentException("explicitFlushAfterFlushes: " + n4 + " (expected: > 0)");
        }
        this.explicitFlushAfterFlushes = n4;
        this.consolidateWhenNoReadInProgress = bl3;
        this.flushTask = bl3 ? new FlushConsolidationHandler$1(this) : null;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.readInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(channelHandlerContext);
            }
        } else if (this.consolidateWhenNoReadInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(channelHandlerContext);
            } else {
                this.scheduleFlush(channelHandlerContext);
            }
        } else {
            this.flushNow(channelHandlerContext);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.readInProgress = true;
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().isWritable()) {
            this.flushIfNeeded(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.flushIfNeeded(channelHandlerContext);
    }

    private void resetReadAndFlushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        this.readInProgress = false;
        this.flushIfNeeded(channelHandlerContext);
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.flushPendingCount > 0) {
            this.flushNow(channelHandlerContext);
        }
    }

    private void flushNow(ChannelHandlerContext channelHandlerContext) {
        this.cancelScheduledFlush();
        this.flushPendingCount = 0;
        channelHandlerContext.flush();
    }

    private void scheduleFlush(ChannelHandlerContext channelHandlerContext) {
        if (this.nextScheduledFlush == null) {
            this.nextScheduledFlush = channelHandlerContext.channel().eventLoop().submit(this.flushTask);
        }
    }

    private void cancelScheduledFlush() {
        if (this.nextScheduledFlush != null) {
            this.nextScheduledFlush.cancel(false);
            this.nextScheduledFlush = null;
        }
    }

    static /* synthetic */ int access$000(FlushConsolidationHandler flushConsolidationHandler) {
        return flushConsolidationHandler.flushPendingCount;
    }

    static /* synthetic */ boolean access$100(FlushConsolidationHandler flushConsolidationHandler) {
        return flushConsolidationHandler.readInProgress;
    }

    static /* synthetic */ int access$002(FlushConsolidationHandler flushConsolidationHandler, int n4) {
        flushConsolidationHandler.flushPendingCount = n4;
        return flushConsolidationHandler.flushPendingCount;
    }

    static /* synthetic */ ChannelHandlerContext access$200(FlushConsolidationHandler flushConsolidationHandler) {
        return flushConsolidationHandler.ctx;
    }

    static /* synthetic */ Future access$302(FlushConsolidationHandler flushConsolidationHandler, Future future) {
        flushConsolidationHandler.nextScheduledFlush = future;
        return flushConsolidationHandler.nextScheduledFlush;
    }
}

