/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.flow;

import io.grpc.netty.shaded.io.netty.channel.ChannelConfig;
import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.flow.FlowControlHandler$RecyclableArrayDeque;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class FlowControlHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FlowControlHandler.class);
    private final boolean releaseMessages;
    private FlowControlHandler$RecyclableArrayDeque queue;
    private ChannelConfig config;
    private boolean shouldConsume;

    public FlowControlHandler() {
        this(true);
    }

    public FlowControlHandler(boolean bl3) {
        this.releaseMessages = bl3;
    }

    boolean isQueueEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    private void destroy() {
        if (this.queue != null) {
            if (!this.queue.isEmpty()) {
                logger.trace("Non-empty queue: {}", (Object)this.queue);
                if (this.releaseMessages) {
                    Object e10;
                    while ((e10 = this.queue.poll()) != null) {
                        ReferenceCountUtil.safeRelease(e10);
                    }
                }
            }
            this.queue.recycle();
            this.queue = null;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.config = channelHandlerContext.channel().config();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        if (this.dequeue(channelHandlerContext, 1) == 0) {
            this.shouldConsume = true;
            channelHandlerContext.read();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.queue == null) {
            this.queue = FlowControlHandler$RecyclableArrayDeque.newInstance();
        }
        this.queue.offer(object);
        int n4 = this.shouldConsume ? 1 : 0;
        this.shouldConsume = false;
        this.dequeue(channelHandlerContext, n4);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
    }

    private int dequeue(ChannelHandlerContext channelHandlerContext, int n4) {
        Object e10;
        int n7;
        for (n7 = 0; this.queue != null && (n7 < n4 || this.config.isAutoRead()) && (e10 = this.queue.poll()) != null; ++n7) {
            channelHandlerContext.fireChannelRead(e10);
        }
        if (this.queue != null && this.queue.isEmpty()) {
            this.queue.recycle();
            this.queue = null;
            if (n7 > 0) {
                channelHandlerContext.fireChannelReadComplete();
            }
        }
        return n7;
    }
}

