/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.xml;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.CorruptedFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class XmlFrameDecoder
extends ByteToMessageDecoder {
    private final int maxFrameLength;

    public XmlFrameDecoder(int n4) {
        if (n4 < 1) {
            throw new IllegalArgumentException("maxFrameLength must be a positive int");
        }
        this.maxFrameLength = n4;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n4;
        int n7;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        long l2 = 0L;
        int n8 = 0;
        int n10 = 0;
        int n11 = byteBuf.writerIndex();
        if (n11 > this.maxFrameLength) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            this.fail(n11);
            return;
        }
        block0: for (n7 = byteBuf.readerIndex(); n7 < n11; ++n7) {
            byte by2;
            n4 = byteBuf.getByte(n7);
            if (!bl3 && Character.isWhitespace(n4)) {
                ++n10;
                continue;
            }
            if (!bl3 && n4 != 60) {
                XmlFrameDecoder.fail(channelHandlerContext);
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            if (!bl5 && n4 == 60) {
                bl3 = true;
                if (n7 >= n11 - 1) continue;
                by2 = byteBuf.getByte(n7 + 1);
                if (by2 == 47) {
                    for (int i3 = n7 + 2; i3 <= n11 - 1; ++i3) {
                        if (byteBuf.getByte(i3) != 62) continue;
                        --l2;
                        continue block0;
                    }
                    continue;
                }
                if (XmlFrameDecoder.isValidStartCharForXmlElement(by2)) {
                    bl4 = true;
                    ++l2;
                    continue;
                }
                if (by2 == 33) {
                    if (XmlFrameDecoder.isCommentBlockStart(byteBuf, n7)) {
                        ++l2;
                        continue;
                    }
                    if (!XmlFrameDecoder.isCDATABlockStart(byteBuf, n7)) continue;
                    ++l2;
                    bl5 = true;
                    continue;
                }
                if (by2 != 63) continue;
                ++l2;
                continue;
            }
            if (!bl5 && n4 == 47) {
                if (n7 >= n11 - 1 || byteBuf.getByte(n7 + 1) != 62) continue;
                --l2;
                continue;
            }
            if (n4 != 62) continue;
            n8 = n7 + 1;
            if (n7 - 1 > -1) {
                by2 = byteBuf.getByte(n7 - 1);
                if (!bl5) {
                    if (by2 == 63) {
                        --l2;
                    } else if (by2 == 45 && n7 - 2 > -1 && byteBuf.getByte(n7 - 2) == 45) {
                        --l2;
                    }
                } else if (by2 == 93 && n7 - 2 > -1 && byteBuf.getByte(n7 - 2) == 93) {
                    --l2;
                    bl5 = false;
                }
            }
            if (bl4 && l2 == 0L) break;
        }
        n7 = byteBuf.readerIndex();
        n4 = n8 - n7;
        if (l2 == 0L && n4 > 0) {
            if (n7 + n4 >= n11) {
                n4 = byteBuf.readableBytes();
            }
            ByteBuf byteBuf2 = XmlFrameDecoder.extractFrame(byteBuf, n7 + n10, n4 - n10);
            byteBuf.skipBytes(n4);
            list.add(byteBuf2);
        }
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static void fail(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.fireExceptionCaught(new CorruptedFrameException("frame contains content before the xml starts"));
    }

    private static ByteBuf extractFrame(ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.copy(n4, n7);
    }

    private static boolean isValidStartCharForXmlElement(byte by2) {
        return by2 >= 97 && by2 <= 122 || by2 >= 65 && by2 <= 90 || by2 == 58 || by2 == 95;
    }

    private static boolean isCommentBlockStart(ByteBuf byteBuf, int n4) {
        return n4 < byteBuf.writerIndex() - 3 && byteBuf.getByte(n4 + 2) == 45 && byteBuf.getByte(n4 + 3) == 45;
    }

    private static boolean isCDATABlockStart(ByteBuf byteBuf, int n4) {
        return n4 < byteBuf.writerIndex() - 8 && byteBuf.getByte(n4 + 2) == 91 && byteBuf.getByte(n4 + 3) == 67 && byteBuf.getByte(n4 + 4) == 68 && byteBuf.getByte(n4 + 5) == 65 && byteBuf.getByte(n4 + 6) == 84 && byteBuf.getByte(n4 + 7) == 65 && byteBuf.getByte(n4 + 8) == 91;
    }
}

