/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyDataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyPingFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyProtocolException;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySession;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySession$PendingWrite;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySessionHandler$1;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySessionHandler$2;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySessionHandler$3;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySessionHandler$4;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySessionHandler$ClosingChannelFutureListener;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySessionStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ThrowableUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class SpdySessionHandler
extends ChannelDuplexHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = ThrowableUtil.unknownStackTrace(SpdyProtocolException.newStatic(null), SpdySessionHandler.class, "handleOutboundMessage(...)");
    private static final SpdyProtocolException STREAM_CLOSED = ThrowableUtil.unknownStackTrace(SpdyProtocolException.newStatic("Stream closed"), SpdySessionHandler.class, "removeStream(...)");
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private int initialSendWindowSize = 65536;
    private int initialReceiveWindowSize = 65536;
    private volatile int initialSessionReceiveWindowSize = 65536;
    private final SpdySession spdySession = new SpdySession(this.initialSendWindowSize, this.initialReceiveWindowSize);
    private int lastGoodStreamId;
    private static final int DEFAULT_MAX_CONCURRENT_STREAMS = Integer.MAX_VALUE;
    private int remoteConcurrentStreams = Integer.MAX_VALUE;
    private int localConcurrentStreams = Integer.MAX_VALUE;
    private final AtomicInteger pings = new AtomicInteger();
    private boolean sentGoAwayFrame;
    private boolean receivedGoAwayFrame;
    private ChannelFutureListener closeSessionFutureListener;
    private final boolean server;
    private final int minorVersion;

    public SpdySessionHandler(SpdyVersion spdyVersion, boolean bl3) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        this.server = bl3;
        this.minorVersion = spdyVersion.getMinorVersion();
    }

    public void setSessionReceiveWindowSize(int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "sessionReceiveWindowSize");
        this.initialSessionReceiveWindowSize = n4;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof SpdyDataFrame) {
            SpdyFrame spdyFrame;
            int n4;
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            int n7 = spdyDataFrame.streamId();
            int n8 = -1 * spdyDataFrame.content().readableBytes();
            int n10 = this.spdySession.updateReceiveWindowSize(0, n8);
            if (n10 < 0) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            if (n10 <= this.initialSessionReceiveWindowSize / 2) {
                n4 = this.initialSessionReceiveWindowSize - n10;
                this.spdySession.updateReceiveWindowSize(0, n4);
                spdyFrame = new DefaultSpdyWindowUpdateFrame(0, n4);
                channelHandlerContext.writeAndFlush(spdyFrame);
            }
            if (!this.spdySession.isActiveStream(n7)) {
                spdyDataFrame.release();
                if (n7 <= this.lastGoodStreamId) {
                    this.issueStreamError(channelHandlerContext, n7, SpdyStreamStatus.PROTOCOL_ERROR);
                } else if (!this.sentGoAwayFrame) {
                    this.issueStreamError(channelHandlerContext, n7, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(n7)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n7, SpdyStreamStatus.STREAM_ALREADY_CLOSED);
                return;
            }
            if (!this.isRemoteInitiatedId(n7) && !this.spdySession.hasReceivedReply(n7)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n7, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            n4 = this.spdySession.updateReceiveWindowSize(n7, n8);
            if (n4 < this.spdySession.getReceiveWindowSizeLowerBound(n7)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n7, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                return;
            }
            if (n4 < 0) {
                while (spdyDataFrame.content().readableBytes() > this.initialReceiveWindowSize) {
                    spdyFrame = new DefaultSpdyDataFrame(n7, spdyDataFrame.content().readRetainedSlice(this.initialReceiveWindowSize));
                    channelHandlerContext.writeAndFlush(spdyFrame);
                }
            }
            if (n4 <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                int n11 = this.initialReceiveWindowSize - n4;
                this.spdySession.updateReceiveWindowSize(n7, n11);
                DefaultSpdyWindowUpdateFrame defaultSpdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(n7, n11);
                channelHandlerContext.writeAndFlush(defaultSpdyWindowUpdateFrame);
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n7, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdySynStreamFrame) {
            boolean bl3;
            boolean bl4;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            int n12 = spdySynStreamFrame.streamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedId(n12) || this.spdySession.isActiveStream(n12)) {
                this.issueStreamError(channelHandlerContext, n12, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (n12 <= this.lastGoodStreamId) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte by2 = spdySynStreamFrame.priority();
            if (!this.acceptStream(n12, by2, bl4 = spdySynStreamFrame.isLast(), bl3 = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(channelHandlerContext, n12, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (object instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            int n13 = spdySynReplyFrame.streamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedId(n13) || this.spdySession.isRemoteSideClosed(n13)) {
                this.issueStreamError(channelHandlerContext, n13, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(n13)) {
                this.issueStreamError(channelHandlerContext, n13, SpdyStreamStatus.STREAM_IN_USE);
                return;
            }
            this.spdySession.receivedReply(n13);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(n13, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            this.removeStream(spdyRstStreamFrame.streamId(), channelHandlerContext.newSucceededFuture());
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            int n14 = spdySettingsFrame.getValue(0);
            if (n14 >= 0 && n14 != this.minorVersion) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            int n15 = spdySettingsFrame.getValue(4);
            if (n15 >= 0) {
                this.remoteConcurrentStreams = n15;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int n16 = spdySettingsFrame.getValue(7);
            if (n16 >= 0) {
                this.updateInitialSendWindowSize(n16);
            }
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                channelHandlerContext.writeAndFlush(spdyPingFrame);
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (object instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (object instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
            int n17 = spdyHeadersFrame.streamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(channelHandlerContext, n17, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(n17)) {
                this.issueStreamError(channelHandlerContext, n17, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(n17, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdyWindowUpdateFrame) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)object;
            int n18 = spdyWindowUpdateFrame.streamId();
            int n19 = spdyWindowUpdateFrame.deltaWindowSize();
            if (n18 != 0 && this.spdySession.isLocalSideClosed(n18)) {
                return;
            }
            if (this.spdySession.getSendWindowSize(n18) > Integer.MAX_VALUE - n19) {
                if (n18 == 0) {
                    this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                } else {
                    this.issueStreamError(channelHandlerContext, n18, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                }
                return;
            }
            this.updateSendWindowSize(channelHandlerContext, n18, n19);
        }
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        for (Integer n4 : this.spdySession.activeStreams().keySet()) {
            this.removeStream(n4, channelHandlerContext.newSucceededFuture());
        }
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof SpdyProtocolException) {
            this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
        }
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.sendGoAwayFrame(channelHandlerContext, channelPromise);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame || object instanceof SpdySynStreamFrame || object instanceof SpdySynReplyFrame || object instanceof SpdyRstStreamFrame || object instanceof SpdySettingsFrame || object instanceof SpdyPingFrame || object instanceof SpdyGoAwayFrame || object instanceof SpdyHeadersFrame || object instanceof SpdyWindowUpdateFrame) {
            this.handleOutboundMessage(channelHandlerContext, object, channelPromise);
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    private void handleOutboundMessage(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            int n4 = spdyDataFrame.streamId();
            if (this.spdySession.isLocalSideClosed(n4)) {
                spdyDataFrame.release();
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            int n7 = spdyDataFrame.content().readableBytes();
            int n8 = this.spdySession.getSendWindowSize(n4);
            int n10 = this.spdySession.getSendWindowSize(0);
            if ((n8 = Math.min(n8, n10)) <= 0) {
                this.spdySession.putPendingWrite(n4, new SpdySession$PendingWrite(spdyDataFrame, channelPromise));
                return;
            }
            if (n8 < n7) {
                this.spdySession.updateSendWindowSize(n4, -1 * n8);
                this.spdySession.updateSendWindowSize(0, -1 * n8);
                DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n4, spdyDataFrame.content().readRetainedSlice(n8));
                this.spdySession.putPendingWrite(n4, new SpdySession$PendingWrite(spdyDataFrame, channelPromise));
                ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
                channelHandlerContext.write(defaultSpdyDataFrame).addListener(new SpdySessionHandler$1(this, channelHandlerContext2));
                return;
            }
            this.spdySession.updateSendWindowSize(n4, -1 * n7);
            this.spdySession.updateSendWindowSize(0, -1 * n7);
            ChannelHandlerContext channelHandlerContext3 = channelHandlerContext;
            channelPromise.addListener(new SpdySessionHandler$2(this, channelHandlerContext3));
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n4, false, channelPromise);
            }
        } else if (object instanceof SpdySynStreamFrame) {
            boolean bl3;
            boolean bl4;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            int n11 = spdySynStreamFrame.streamId();
            if (this.isRemoteInitiatedId(n11)) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            byte by2 = spdySynStreamFrame.priority();
            if (!this.acceptStream(n11, by2, bl4 = spdySynStreamFrame.isUnidirectional(), bl3 = spdySynStreamFrame.isLast())) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        } else if (object instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            int n12 = spdySynReplyFrame.streamId();
            if (!this.isRemoteInitiatedId(n12) || this.spdySession.isLocalSideClosed(n12)) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(n12, false, channelPromise);
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            this.removeStream(spdyRstStreamFrame.streamId(), channelPromise);
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            int n13 = spdySettingsFrame.getValue(0);
            if (n13 >= 0 && n13 != this.minorVersion) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            int n14 = spdySettingsFrame.getValue(4);
            if (n14 >= 0) {
                this.localConcurrentStreams = n14;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int n15 = spdySettingsFrame.getValue(7);
            if (n15 >= 0) {
                this.updateInitialReceiveWindowSize(n15);
            }
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                channelHandlerContext.fireExceptionCaught(new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.id()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (object instanceof SpdyGoAwayFrame) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (object instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
                int n16 = spdyHeadersFrame.streamId();
                if (this.spdySession.isLocalSideClosed(n16)) {
                    channelPromise.setFailure(PROTOCOL_EXCEPTION);
                    return;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(n16, false, channelPromise);
                }
            } else if (object instanceof SpdyWindowUpdateFrame) {
                channelPromise.setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        }
        channelHandlerContext.write(object, channelPromise);
    }

    private void issueSessionError(ChannelHandlerContext channelHandlerContext, SpdySessionStatus spdySessionStatus) {
        this.sendGoAwayFrame(channelHandlerContext, spdySessionStatus).addListener(new SpdySessionHandler$ClosingChannelFutureListener(channelHandlerContext, channelHandlerContext.newPromise()));
    }

    private void issueStreamError(ChannelHandlerContext channelHandlerContext, int n4, SpdyStreamStatus spdyStreamStatus) {
        boolean bl3 = !this.spdySession.isRemoteSideClosed(n4);
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        this.removeStream(n4, channelPromise);
        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, spdyStreamStatus);
        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame, channelPromise);
        if (bl3) {
            channelHandlerContext.fireChannelRead(defaultSpdyRstStreamFrame);
        }
    }

    private boolean isRemoteInitiatedId(int n4) {
        boolean bl3 = SpdyCodecUtil.isServerId(n4);
        return this.server && !bl3 || !this.server && bl3;
    }

    private void updateInitialSendWindowSize(int n4) {
        int n7 = n4 - this.initialSendWindowSize;
        this.initialSendWindowSize = n4;
        this.spdySession.updateAllSendWindowSizes(n7);
    }

    private void updateInitialReceiveWindowSize(int n4) {
        int n7 = n4 - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = n4;
        this.spdySession.updateAllReceiveWindowSizes(n7);
    }

    private boolean acceptStream(int n4, byte by2, boolean bl3, boolean bl4) {
        int n7;
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        boolean bl5 = this.isRemoteInitiatedId(n4);
        int n8 = n7 = bl5 ? this.localConcurrentStreams : this.remoteConcurrentStreams;
        if (this.spdySession.numActiveStreams(bl5) >= n7) {
            return false;
        }
        this.spdySession.acceptStream(n4, by2, bl3, bl4, this.initialSendWindowSize, this.initialReceiveWindowSize, bl5);
        if (bl5) {
            this.lastGoodStreamId = n4;
        }
        return true;
    }

    private void halfCloseStream(int n4, boolean bl3, ChannelFuture channelFuture) {
        if (bl3) {
            this.spdySession.closeRemoteSide(n4, this.isRemoteInitiatedId(n4));
        } else {
            this.spdySession.closeLocalSide(n4, this.isRemoteInitiatedId(n4));
        }
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            channelFuture.addListener(this.closeSessionFutureListener);
        }
    }

    private void removeStream(int n4, ChannelFuture channelFuture) {
        this.spdySession.removeStream(n4, STREAM_CLOSED, this.isRemoteInitiatedId(n4));
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            channelFuture.addListener(this.closeSessionFutureListener);
        }
    }

    private void updateSendWindowSize(ChannelHandlerContext channelHandlerContext, int n4, int n7) {
        this.spdySession.updateSendWindowSize(n4, n7);
        SpdySession$PendingWrite spdySession$PendingWrite;
        while ((spdySession$PendingWrite = this.spdySession.getPendingWrite(n4)) != null) {
            SpdyDataFrame spdyDataFrame = spdySession$PendingWrite.spdyDataFrame;
            int n8 = spdyDataFrame.content().readableBytes();
            int n10 = spdyDataFrame.streamId();
            int n11 = this.spdySession.getSendWindowSize(n10);
            int n12 = this.spdySession.getSendWindowSize(0);
            if ((n11 = Math.min(n11, n12)) <= 0) {
                return;
            }
            if (n11 < n8) {
                this.spdySession.updateSendWindowSize(n10, -1 * n11);
                this.spdySession.updateSendWindowSize(0, -1 * n11);
                DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n10, spdyDataFrame.content().readRetainedSlice(n11));
                channelHandlerContext.writeAndFlush(defaultSpdyDataFrame).addListener(new SpdySessionHandler$3(this, channelHandlerContext));
                continue;
            }
            this.spdySession.removePendingWrite(n10);
            this.spdySession.updateSendWindowSize(n10, -1 * n8);
            this.spdySession.updateSendWindowSize(0, -1 * n8);
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n10, false, spdySession$PendingWrite.promise);
            }
            channelHandlerContext.writeAndFlush(spdyDataFrame, spdySession$PendingWrite.promise).addListener(new SpdySessionHandler$4(this, channelHandlerContext));
        }
        return;
    }

    private void sendGoAwayFrame(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ChannelFuture channelFuture = this.sendGoAwayFrame(channelHandlerContext, SpdySessionStatus.OK);
        if (this.spdySession.noActiveStreams()) {
            channelFuture.addListener(new SpdySessionHandler$ClosingChannelFutureListener(channelHandlerContext, channelPromise));
        } else {
            this.closeSessionFutureListener = new SpdySessionHandler$ClosingChannelFutureListener(channelHandlerContext, channelPromise);
        }
    }

    private ChannelFuture sendGoAwayFrame(ChannelHandlerContext channelHandlerContext, SpdySessionStatus spdySessionStatus) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            DefaultSpdyGoAwayFrame defaultSpdyGoAwayFrame = new DefaultSpdyGoAwayFrame(this.lastGoodStreamId, spdySessionStatus);
            return channelHandlerContext.writeAndFlush(defaultSpdyGoAwayFrame);
        }
        return channelHandlerContext.newSucceededFuture();
    }

    static /* synthetic */ void access$000(SpdySessionHandler spdySessionHandler, ChannelHandlerContext channelHandlerContext, SpdySessionStatus spdySessionStatus) {
        spdySessionHandler.issueSessionError(channelHandlerContext, spdySessionStatus);
    }
}

