/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySession$PendingWrite;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySession$StreamComparator;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySession$StreamState;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

final class SpdySession {
    private final AtomicInteger activeLocalStreams = new AtomicInteger();
    private final AtomicInteger activeRemoteStreams = new AtomicInteger();
    private final Map<Integer, SpdySession$StreamState> activeStreams = PlatformDependent.newConcurrentHashMap();
    private final SpdySession$StreamComparator streamComparator = new SpdySession$StreamComparator(this);
    private final AtomicInteger sendWindowSize;
    private final AtomicInteger receiveWindowSize;

    SpdySession(int n4, int n7) {
        this.sendWindowSize = new AtomicInteger(n4);
        this.receiveWindowSize = new AtomicInteger(n7);
    }

    int numActiveStreams(boolean bl3) {
        if (bl3) {
            return this.activeRemoteStreams.get();
        }
        return this.activeLocalStreams.get();
    }

    boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    boolean isActiveStream(int n4) {
        return this.activeStreams.containsKey(n4);
    }

    Map<Integer, SpdySession$StreamState> activeStreams() {
        TreeMap<Integer, SpdySession$StreamState> treeMap = new TreeMap<Integer, SpdySession$StreamState>(this.streamComparator);
        treeMap.putAll(this.activeStreams);
        return treeMap;
    }

    void acceptStream(int n4, byte by2, boolean bl3, boolean bl4, int n7, int n8, boolean bl5) {
        SpdySession$StreamState spdySession$StreamState;
        if (!(bl3 && bl4 || (spdySession$StreamState = this.activeStreams.put(n4, new SpdySession$StreamState(by2, bl3, bl4, n7, n8))) != null)) {
            if (bl5) {
                this.activeRemoteStreams.incrementAndGet();
            } else {
                this.activeLocalStreams.incrementAndGet();
            }
        }
    }

    private SpdySession$StreamState removeActiveStream(int n4, boolean bl3) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.remove(n4);
        if (spdySession$StreamState != null) {
            if (bl3) {
                this.activeRemoteStreams.decrementAndGet();
            } else {
                this.activeLocalStreams.decrementAndGet();
            }
        }
        return spdySession$StreamState;
    }

    void removeStream(int n4, Throwable throwable, boolean bl3) {
        SpdySession$StreamState spdySession$StreamState = this.removeActiveStream(n4, bl3);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.clearPendingWrites(throwable);
        }
    }

    boolean isRemoteSideClosed(int n4) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState == null || spdySession$StreamState.isRemoteSideClosed();
    }

    void closeRemoteSide(int n4, boolean bl3) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeRemoteSide();
            if (spdySession$StreamState.isLocalSideClosed()) {
                this.removeActiveStream(n4, bl3);
            }
        }
    }

    boolean isLocalSideClosed(int n4) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState == null || spdySession$StreamState.isLocalSideClosed();
    }

    void closeLocalSide(int n4, boolean bl3) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeLocalSide();
            if (spdySession$StreamState.isRemoteSideClosed()) {
                this.removeActiveStream(n4, bl3);
            }
        }
    }

    boolean hasReceivedReply(int n4) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState != null && spdySession$StreamState.hasReceivedReply();
    }

    void receivedReply(int n4) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.receivedReply();
        }
    }

    int getSendWindowSize(int n4) {
        if (n4 == 0) {
            return this.sendWindowSize.get();
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState != null ? spdySession$StreamState.getSendWindowSize() : -1;
    }

    int updateSendWindowSize(int n4, int n7) {
        if (n4 == 0) {
            return this.sendWindowSize.addAndGet(n7);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState != null ? spdySession$StreamState.updateSendWindowSize(n7) : -1;
    }

    int updateReceiveWindowSize(int n4, int n7) {
        if (n4 == 0) {
            return this.receiveWindowSize.addAndGet(n7);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        if (spdySession$StreamState == null) {
            return -1;
        }
        if (n7 > 0) {
            spdySession$StreamState.setReceiveWindowSizeLowerBound(0);
        }
        return spdySession$StreamState.updateReceiveWindowSize(n7);
    }

    int getReceiveWindowSizeLowerBound(int n4) {
        if (n4 == 0) {
            return 0;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState != null ? spdySession$StreamState.getReceiveWindowSizeLowerBound() : 0;
    }

    void updateAllSendWindowSizes(int n4) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateSendWindowSize(n4);
        }
    }

    void updateAllReceiveWindowSizes(int n4) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateReceiveWindowSize(n4);
            if (n4 >= 0) continue;
            spdySession$StreamState.setReceiveWindowSizeLowerBound(n4);
        }
    }

    boolean putPendingWrite(int n4, SpdySession$PendingWrite spdySession$PendingWrite) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState != null && spdySession$StreamState.putPendingWrite(spdySession$PendingWrite);
    }

    SpdySession$PendingWrite getPendingWrite(int n4) {
        if (n4 == 0) {
            for (Map.Entry<Integer, SpdySession$StreamState> entry : this.activeStreams().entrySet()) {
                SpdySession$PendingWrite spdySession$PendingWrite;
                SpdySession$StreamState spdySession$StreamState = entry.getValue();
                if (spdySession$StreamState.getSendWindowSize() <= 0 || (spdySession$PendingWrite = spdySession$StreamState.getPendingWrite()) == null) continue;
                return spdySession$PendingWrite;
            }
            return null;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState != null ? spdySession$StreamState.getPendingWrite() : null;
    }

    SpdySession$PendingWrite removePendingWrite(int n4) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n4);
        return spdySession$StreamState != null ? spdySession$StreamState.removePendingWrite() : null;
    }

    static /* synthetic */ Map access$000(SpdySession spdySession) {
        return spdySession.activeStreams;
    }
}

