/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHttpHeaders$Names;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<Object, HttpMessage> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new ArrayDeque<Integer>();

    @Override
    public boolean acceptInboundMessage(Object object) {
        return object instanceof HttpMessage || object instanceof SpdyRstStreamFrame;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage, List<Object> list) {
        Integer n4 = this.ids.poll();
        if (n4 != null && n4.intValue() != NO_ID.intValue() && !httpMessage.headers().contains(SpdyHttpHeaders$Names.STREAM_ID)) {
            httpMessage.headers().setInt(SpdyHttpHeaders$Names.STREAM_ID, n4);
        }
        list.add(ReferenceCountUtil.retain(httpMessage));
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) {
        if (object instanceof HttpMessage) {
            boolean bl3 = ((HttpMessage)object).headers().contains(SpdyHttpHeaders$Names.STREAM_ID);
            if (!bl3) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(((HttpMessage)object).headers().getInt(SpdyHttpHeaders$Names.STREAM_ID));
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)object).streamId());
        }
        list.add(ReferenceCountUtil.retain(object));
    }
}

