/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.UnsupportedMessageTypeException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaders$HttpNames;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHttpHeaders$Names;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpEncoder
extends MessageToMessageEncoder<HttpObject> {
    private int currentStreamId;
    private final boolean validateHeaders;
    private final boolean headersToLowerCase;

    public SpdyHttpEncoder(SpdyVersion spdyVersion) {
        this(spdyVersion, true, true);
    }

    public SpdyHttpEncoder(SpdyVersion spdyVersion, boolean bl3, boolean bl4) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        this.headersToLowerCase = bl3;
        this.validateHeaders = bl4;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        SpdyStreamFrame spdyStreamFrame;
        HttpObject httpObject2;
        boolean bl3 = false;
        boolean bl4 = false;
        if (httpObject instanceof HttpRequest) {
            httpObject2 = (HttpRequest)httpObject;
            spdyStreamFrame = this.createSynStreamFrame((HttpRequest)httpObject2);
            list.add(spdyStreamFrame);
            bl4 = spdyStreamFrame.isLast() || spdyStreamFrame.isUnidirectional();
            bl3 = true;
        }
        if (httpObject instanceof HttpResponse) {
            httpObject2 = (HttpResponse)httpObject;
            spdyStreamFrame = this.createHeadersFrame((HttpResponse)httpObject2);
            list.add(spdyStreamFrame);
            bl4 = spdyStreamFrame.isLast();
            bl3 = true;
        }
        if (httpObject instanceof HttpContent && !bl4) {
            httpObject2 = (HttpContent)httpObject;
            httpObject2.content().retain();
            spdyStreamFrame = new DefaultSpdyDataFrame(this.currentStreamId, httpObject2.content());
            if (httpObject2 instanceof LastHttpContent) {
                LastHttpContent lastHttpContent = (LastHttpContent)httpObject2;
                HttpHeaders httpHeaders = lastHttpContent.trailingHeaders();
                if (httpHeaders.isEmpty()) {
                    spdyStreamFrame.setLast(true);
                    list.add(spdyStreamFrame);
                } else {
                    DefaultSpdyHeadersFrame defaultSpdyHeadersFrame = new DefaultSpdyHeadersFrame(this.currentStreamId, this.validateHeaders);
                    defaultSpdyHeadersFrame.setLast(true);
                    Iterator<Map.Entry<CharSequence, CharSequence>> iterator = httpHeaders.iteratorCharSequence();
                    while (iterator.hasNext()) {
                        Map.Entry<CharSequence, CharSequence> entry = iterator.next();
                        CharSequence charSequence = this.headersToLowerCase ? AsciiString.of(entry.getKey()).toLowerCase() : entry.getKey();
                        defaultSpdyHeadersFrame.headers().add(charSequence, entry.getValue());
                    }
                    list.add(spdyStreamFrame);
                    list.add(defaultSpdyHeadersFrame);
                }
            } else {
                list.add(spdyStreamFrame);
            }
            bl3 = true;
        }
        if (!bl3) {
            throw new UnsupportedMessageTypeException(httpObject, new Class[0]);
        }
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpRequest httpRequest) {
        HttpHeaders httpHeaders = httpRequest.headers();
        int n4 = httpHeaders.getInt(SpdyHttpHeaders$Names.STREAM_ID);
        int n7 = httpHeaders.getInt(SpdyHttpHeaders$Names.ASSOCIATED_TO_STREAM_ID, 0);
        byte by2 = (byte)httpHeaders.getInt(SpdyHttpHeaders$Names.PRIORITY, 0);
        String string = httpHeaders.get(SpdyHttpHeaders$Names.SCHEME);
        httpHeaders.remove(SpdyHttpHeaders$Names.STREAM_ID);
        httpHeaders.remove(SpdyHttpHeaders$Names.ASSOCIATED_TO_STREAM_ID);
        httpHeaders.remove(SpdyHttpHeaders$Names.PRIORITY);
        httpHeaders.remove(SpdyHttpHeaders$Names.SCHEME);
        httpHeaders.remove(HttpHeaderNames.CONNECTION);
        httpHeaders.remove("Keep-Alive");
        httpHeaders.remove("Proxy-Connection");
        httpHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
        DefaultSpdySynStreamFrame defaultSpdySynStreamFrame = new DefaultSpdySynStreamFrame(n4, n7, by2, this.validateHeaders);
        SpdyHeaders spdyHeaders = defaultSpdySynStreamFrame.headers();
        spdyHeaders.set(SpdyHeaders$HttpNames.METHOD, httpRequest.method().name());
        spdyHeaders.set(SpdyHeaders$HttpNames.PATH, httpRequest.uri());
        spdyHeaders.set(SpdyHeaders$HttpNames.VERSION, httpRequest.protocolVersion().text());
        String string2 = httpHeaders.get(HttpHeaderNames.HOST);
        httpHeaders.remove(HttpHeaderNames.HOST);
        spdyHeaders.set(SpdyHeaders$HttpNames.HOST, string2);
        if (string == null) {
            string = "https";
        }
        spdyHeaders.set(SpdyHeaders$HttpNames.SCHEME, string);
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = httpHeaders.iteratorCharSequence();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            CharSequence charSequence = this.headersToLowerCase ? AsciiString.of(entry.getKey()).toLowerCase() : entry.getKey();
            spdyHeaders.add(charSequence, entry.getValue());
        }
        this.currentStreamId = defaultSpdySynStreamFrame.streamId();
        if (n7 == 0) {
            defaultSpdySynStreamFrame.setLast(SpdyHttpEncoder.isLast(httpRequest));
        } else {
            defaultSpdySynStreamFrame.setUnidirectional(true);
        }
        return defaultSpdySynStreamFrame;
    }

    private SpdyHeadersFrame createHeadersFrame(HttpResponse httpResponse) {
        HttpHeaders httpHeaders = httpResponse.headers();
        int n4 = httpHeaders.getInt(SpdyHttpHeaders$Names.STREAM_ID);
        httpHeaders.remove(SpdyHttpHeaders$Names.STREAM_ID);
        httpHeaders.remove(HttpHeaderNames.CONNECTION);
        httpHeaders.remove("Keep-Alive");
        httpHeaders.remove("Proxy-Connection");
        httpHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
        DefaultSpdyHeadersFrame defaultSpdyHeadersFrame = SpdyCodecUtil.isServerId(n4) ? new DefaultSpdyHeadersFrame(n4, this.validateHeaders) : new DefaultSpdySynReplyFrame(n4, this.validateHeaders);
        SpdyHeaders spdyHeaders = defaultSpdyHeadersFrame.headers();
        spdyHeaders.set(SpdyHeaders$HttpNames.STATUS, httpResponse.status().codeAsText());
        spdyHeaders.set(SpdyHeaders$HttpNames.VERSION, httpResponse.protocolVersion().text());
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = httpHeaders.iteratorCharSequence();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            CharSequence charSequence = this.headersToLowerCase ? AsciiString.of(entry.getKey()).toLowerCase() : entry.getKey();
            defaultSpdyHeadersFrame.headers().add(charSequence, entry.getValue());
        }
        this.currentStreamId = n4;
        defaultSpdyHeadersFrame.setLast(SpdyHttpEncoder.isLast(httpResponse));
        return defaultSpdyHeadersFrame;
    }

    private static boolean isLast(HttpMessage httpMessage) {
        FullHttpMessage fullHttpMessage;
        return httpMessage instanceof FullHttpMessage && (fullHttpMessage = (FullHttpMessage)httpMessage).trailingHeaders().isEmpty() && !fullHttpMessage.content().isReadable();
    }
}

