/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyDataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaders$HttpNames;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHttpHeaders$Names;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpdyHttpDecoder
extends MessageToMessageDecoder<SpdyFrame> {
    private final boolean validateHeaders;
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, FullHttpMessage> messageMap;

    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n4) {
        this(spdyVersion, n4, new HashMap<Integer, FullHttpMessage>(), true);
    }

    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n4, boolean bl3) {
        this(spdyVersion, n4, new HashMap<Integer, FullHttpMessage>(), bl3);
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n4, Map<Integer, FullHttpMessage> map) {
        this(spdyVersion, n4, map, true);
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n4, Map<Integer, FullHttpMessage> map, boolean bl3) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        ObjectUtil.checkPositive(n4, "maxContentLength");
        this.spdyVersion = spdyVersion.getVersion();
        this.maxContentLength = n4;
        this.messageMap = map;
        this.validateHeaders = bl3;
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        for (Map.Entry<Integer, FullHttpMessage> entry : this.messageMap.entrySet()) {
            ReferenceCountUtil.safeRelease(entry.getValue());
        }
        this.messageMap.clear();
        super.channelInactive(channelHandlerContext);
    }

    protected FullHttpMessage putMessage(int n4, FullHttpMessage fullHttpMessage) {
        return this.messageMap.put(n4, fullHttpMessage);
    }

    protected FullHttpMessage getMessage(int n4) {
        return this.messageMap.get(n4);
    }

    protected FullHttpMessage removeMessage(int n4) {
        return this.messageMap.remove(n4);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, SpdyFrame spdyFrame, List<Object> list) {
        block37: {
            if (spdyFrame instanceof SpdySynStreamFrame) {
                SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)spdyFrame;
                int n4 = spdySynStreamFrame.streamId();
                if (SpdyCodecUtil.isServerId(n4)) {
                    int n7 = spdySynStreamFrame.associatedStreamId();
                    if (n7 == 0) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, SpdyStreamStatus.INVALID_STREAM);
                        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                        return;
                    }
                    if (spdySynStreamFrame.isLast()) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, SpdyStreamStatus.PROTOCOL_ERROR);
                        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                        return;
                    }
                    if (spdySynStreamFrame.isTruncated()) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, SpdyStreamStatus.INTERNAL_ERROR);
                        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                        return;
                    }
                    try {
                        FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest(spdySynStreamFrame, channelHandlerContext.alloc());
                        fullHttpRequest.headers().setInt(SpdyHttpHeaders$Names.STREAM_ID, n4);
                        fullHttpRequest.headers().setInt(SpdyHttpHeaders$Names.ASSOCIATED_TO_STREAM_ID, n7);
                        fullHttpRequest.headers().setInt(SpdyHttpHeaders$Names.PRIORITY, spdySynStreamFrame.priority());
                        list.add(fullHttpRequest);
                    }
                    catch (Throwable throwable) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, SpdyStreamStatus.PROTOCOL_ERROR);
                        channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                    }
                } else {
                    if (spdySynStreamFrame.isTruncated()) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n4);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders spdyHeaders = defaultSpdySynReplyFrame.headers();
                        spdyHeaders.setInt(SpdyHeaders$HttpNames.STATUS, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.code());
                        spdyHeaders.setObject(SpdyHeaders$HttpNames.VERSION, (Object)HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush(defaultSpdySynReplyFrame);
                        return;
                    }
                    try {
                        FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest(spdySynStreamFrame, channelHandlerContext.alloc());
                        fullHttpRequest.headers().setInt(SpdyHttpHeaders$Names.STREAM_ID, n4);
                        if (spdySynStreamFrame.isLast()) {
                            list.add(fullHttpRequest);
                            break block37;
                        }
                        this.putMessage(n4, fullHttpRequest);
                    }
                    catch (Throwable throwable) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n4);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders spdyHeaders = defaultSpdySynReplyFrame.headers();
                        spdyHeaders.setInt(SpdyHeaders$HttpNames.STATUS, HttpResponseStatus.BAD_REQUEST.code());
                        spdyHeaders.setObject(SpdyHeaders$HttpNames.VERSION, (Object)HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush(defaultSpdySynReplyFrame);
                    }
                }
            } else if (spdyFrame instanceof SpdySynReplyFrame) {
                SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)spdyFrame;
                int n8 = spdySynReplyFrame.streamId();
                if (spdySynReplyFrame.isTruncated()) {
                    DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n8, SpdyStreamStatus.INTERNAL_ERROR);
                    channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                    return;
                }
                try {
                    FullHttpResponse fullHttpResponse = SpdyHttpDecoder.createHttpResponse(spdySynReplyFrame, channelHandlerContext.alloc(), this.validateHeaders);
                    fullHttpResponse.headers().setInt(SpdyHttpHeaders$Names.STREAM_ID, n8);
                    if (spdySynReplyFrame.isLast()) {
                        HttpUtil.setContentLength(fullHttpResponse, 0L);
                        list.add(fullHttpResponse);
                        break block37;
                    }
                    this.putMessage(n8, fullHttpResponse);
                }
                catch (Throwable throwable) {
                    DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n8, SpdyStreamStatus.PROTOCOL_ERROR);
                    channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                }
            } else if (spdyFrame instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)spdyFrame;
                int n10 = spdyHeadersFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n10);
                if (fullHttpMessage == null) {
                    if (SpdyCodecUtil.isServerId(n10)) {
                        if (spdyHeadersFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n10, SpdyStreamStatus.INTERNAL_ERROR);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                            return;
                        }
                        try {
                            fullHttpMessage = SpdyHttpDecoder.createHttpResponse(spdyHeadersFrame, channelHandlerContext.alloc(), this.validateHeaders);
                            fullHttpMessage.headers().setInt(SpdyHttpHeaders$Names.STREAM_ID, n10);
                            if (spdyHeadersFrame.isLast()) {
                                HttpUtil.setContentLength(fullHttpMessage, 0L);
                                list.add(fullHttpMessage);
                            } else {
                                this.putMessage(n10, fullHttpMessage);
                            }
                        }
                        catch (Throwable throwable) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n10, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush(defaultSpdyRstStreamFrame);
                        }
                    }
                    return;
                }
                if (!spdyHeadersFrame.isTruncated()) {
                    for (Map.Entry entry : spdyHeadersFrame.headers()) {
                        fullHttpMessage.headers().add((CharSequence)entry.getKey(), entry.getValue());
                    }
                }
                if (spdyHeadersFrame.isLast()) {
                    HttpUtil.setContentLength(fullHttpMessage, fullHttpMessage.content().readableBytes());
                    this.removeMessage(n10);
                    list.add(fullHttpMessage);
                }
            } else if (spdyFrame instanceof SpdyDataFrame) {
                SpdyDataFrame spdyDataFrame = (SpdyDataFrame)spdyFrame;
                int n11 = spdyDataFrame.streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n11);
                if (fullHttpMessage == null) {
                    return;
                }
                ByteBuf byteBuf = fullHttpMessage.content();
                if (byteBuf.readableBytes() > this.maxContentLength - spdyDataFrame.content().readableBytes()) {
                    this.removeMessage(n11);
                    throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
                }
                ByteBuf byteBuf2 = spdyDataFrame.content();
                int n12 = byteBuf2.readableBytes();
                byteBuf.writeBytes(byteBuf2, byteBuf2.readerIndex(), n12);
                if (spdyDataFrame.isLast()) {
                    HttpUtil.setContentLength(fullHttpMessage, byteBuf.readableBytes());
                    this.removeMessage(n11);
                    list.add(fullHttpMessage);
                }
            } else if (spdyFrame instanceof SpdyRstStreamFrame) {
                SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)spdyFrame;
                int n13 = spdyRstStreamFrame.streamId();
                this.removeMessage(n13);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FullHttpRequest createHttpRequest(SpdyHeadersFrame spdyHeadersFrame, ByteBufAllocator byteBufAllocator) {
        SpdyHeaders spdyHeaders = spdyHeadersFrame.headers();
        HttpMethod httpMethod = HttpMethod.valueOf(spdyHeaders.getAsString(SpdyHeaders$HttpNames.METHOD));
        String string = spdyHeaders.getAsString(SpdyHeaders$HttpNames.PATH);
        HttpVersion httpVersion = HttpVersion.valueOf(spdyHeaders.getAsString(SpdyHeaders$HttpNames.VERSION));
        spdyHeaders.remove(SpdyHeaders$HttpNames.METHOD);
        spdyHeaders.remove(SpdyHeaders$HttpNames.PATH);
        spdyHeaders.remove(SpdyHeaders$HttpNames.VERSION);
        boolean bl3 = true;
        ByteBuf byteBuf = byteBufAllocator.buffer();
        try {
            DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(httpVersion, httpMethod, string, byteBuf);
            spdyHeaders.remove(SpdyHeaders$HttpNames.SCHEME);
            CharSequence charSequence = (CharSequence)spdyHeaders.get(SpdyHeaders$HttpNames.HOST);
            spdyHeaders.remove(SpdyHeaders$HttpNames.HOST);
            defaultFullHttpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)charSequence);
            for (Map.Entry entry : spdyHeadersFrame.headers()) {
                defaultFullHttpRequest.headers().add((CharSequence)entry.getKey(), entry.getValue());
            }
            HttpUtil.setKeepAlive(defaultFullHttpRequest, true);
            defaultFullHttpRequest.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            bl3 = false;
            DefaultFullHttpRequest defaultFullHttpRequest2 = defaultFullHttpRequest;
            return defaultFullHttpRequest2;
        }
        finally {
            if (bl3) {
                byteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FullHttpResponse createHttpResponse(SpdyHeadersFrame spdyHeadersFrame, ByteBufAllocator byteBufAllocator, boolean bl3) {
        SpdyHeaders spdyHeaders = spdyHeadersFrame.headers();
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.parseLine((CharSequence)spdyHeaders.get(SpdyHeaders$HttpNames.STATUS));
        HttpVersion httpVersion = HttpVersion.valueOf(spdyHeaders.getAsString(SpdyHeaders$HttpNames.VERSION));
        spdyHeaders.remove(SpdyHeaders$HttpNames.STATUS);
        spdyHeaders.remove(SpdyHeaders$HttpNames.VERSION);
        boolean bl4 = true;
        ByteBuf byteBuf = byteBufAllocator.buffer();
        try {
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(httpVersion, httpResponseStatus, byteBuf, bl3);
            for (Map.Entry entry : spdyHeadersFrame.headers()) {
                defaultFullHttpResponse.headers().add((CharSequence)entry.getKey(), entry.getValue());
            }
            HttpUtil.setKeepAlive(defaultFullHttpResponse, true);
            defaultFullHttpResponse.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            defaultFullHttpResponse.headers().remove(HttpHeaderNames.TRAILER);
            bl4 = false;
            DefaultFullHttpResponse defaultFullHttpResponse2 = defaultFullHttpResponse;
            return defaultFullHttpResponse2;
        }
        finally {
            if (bl4) {
                byteBuf.release();
            }
        }
    }
}

