/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import java.util.zip.Deflater;

class SpdyHeaderBlockZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater compressor;
    private boolean finished;

    SpdyHeaderBlockZlibEncoder(SpdyVersion spdyVersion, int n4) {
        super(spdyVersion);
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        this.compressor = new Deflater(n4);
        this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
    }

    private int setInput(ByteBuf byteBuf) {
        int n4 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            this.compressor.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n4);
        } else {
            byte[] byArray = new byte[n4];
            byteBuf.getBytes(byteBuf.readerIndex(), byArray);
            this.compressor.setInput(byArray, 0, byArray.length);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf encode(ByteBufAllocator byteBufAllocator, int n4) {
        ByteBuf byteBuf = byteBufAllocator.heapBuffer(n4);
        boolean bl3 = true;
        try {
            while (this.compressInto(byteBuf)) {
                byteBuf.ensureWritable(byteBuf.capacity() << 1);
            }
            bl3 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl3) {
                byteBuf.release();
            }
        }
    }

    private boolean compressInto(ByteBuf byteBuf) {
        byte[] byArray = byteBuf.array();
        int n4 = byteBuf.arrayOffset() + byteBuf.writerIndex();
        int n7 = byteBuf.writableBytes();
        int n8 = this.compressor.deflate(byArray, n4, n7, 2);
        byteBuf.writerIndex(byteBuf.writerIndex() + n8);
        return n8 == n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator byteBufAllocator, SpdyHeadersFrame spdyHeadersFrame) {
        if (spdyHeadersFrame == null) {
            throw new IllegalArgumentException("frame");
        }
        if (this.finished) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = super.encode(byteBufAllocator, spdyHeadersFrame);
        try {
            if (!byteBuf.isReadable()) {
                ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
                return byteBuf2;
            }
            int n4 = this.setInput(byteBuf);
            ByteBuf byteBuf3 = this.encode(byteBufAllocator, n4);
            return byteBuf3;
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.compressor.end();
        super.end();
    }
}

