/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import java.util.Set;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("version");
        }
        this.version = spdyVersion.getVersion();
    }

    private static void setLengthField(ByteBuf byteBuf, int n4, int n7) {
        byteBuf.setInt(n4, n7);
    }

    private static void writeLengthField(ByteBuf byteBuf, int n4) {
        byteBuf.writeInt(n4);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator byteBufAllocator, SpdyHeadersFrame spdyHeadersFrame) {
        Set set = spdyHeadersFrame.headers().names();
        int n4 = set.size();
        if (n4 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (n4 > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ByteBuf byteBuf = byteBufAllocator.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField(byteBuf, n4);
        for (CharSequence charSequence : set) {
            SpdyHeaderBlockRawEncoder.writeLengthField(byteBuf, charSequence.length());
            ByteBufUtil.writeAscii(byteBuf, charSequence);
            int n7 = byteBuf.writerIndex();
            int n8 = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField(byteBuf, n8);
            for (CharSequence charSequence2 : spdyHeadersFrame.headers().getAll(charSequence)) {
                int n10 = charSequence2.length();
                if (n10 <= 0) continue;
                ByteBufUtil.writeAscii(byteBuf, charSequence2);
                byteBuf.writeByte(0);
                n8 += n10 + 1;
            }
            if (n8 != 0) {
                --n8;
            }
            if (n8 > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + charSequence);
            }
            if (n8 <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField(byteBuf, n7, n8);
            byteBuf.writerIndex(byteBuf.writerIndex() - 1);
        }
        return byteBuf;
    }

    @Override
    void end() {
    }
}

