/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.JZlib;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.CompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;

class SpdyHeaderBlockJZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater z = new Deflater();
    private boolean finished;

    SpdyHeaderBlockJZlibEncoder(SpdyVersion spdyVersion, int n4, int n7, int n8) {
        super(spdyVersion);
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        if (n7 < 9 || n7 > 15) {
            throw new IllegalArgumentException("windowBits: " + n7 + " (expected: 9-15)");
        }
        if (n8 < 1 || n8 > 9) {
            throw new IllegalArgumentException("memLevel: " + n8 + " (expected: 1-9)");
        }
        int n10 = this.z.deflateInit(n4, n7, n8, JZlib.W_ZLIB);
        if (n10 != 0) {
            throw new CompressionException("failed to initialize an SPDY header block deflater: " + n10);
        }
        n10 = this.z.deflateSetDictionary(SpdyCodecUtil.SPDY_DICT, SpdyCodecUtil.SPDY_DICT.length);
        if (n10 != 0) {
            throw new CompressionException("failed to set the SPDY dictionary: " + n10);
        }
    }

    private void setInput(ByteBuf byteBuf) {
        int n4;
        byte[] byArray;
        int n7 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n4 = byteBuf.arrayOffset() + byteBuf.readerIndex();
        } else {
            byArray = new byte[n7];
            byteBuf.getBytes(byteBuf.readerIndex(), byArray);
            n4 = 0;
        }
        this.z.next_in = byArray;
        this.z.next_in_index = n4;
        this.z.avail_in = n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf encode(ByteBufAllocator byteBufAllocator) {
        boolean bl3 = true;
        ReferenceCounted referenceCounted = null;
        try {
            int n4;
            int n7 = this.z.next_in_index;
            int n8 = this.z.next_out_index;
            int n10 = (int)Math.ceil((double)this.z.next_in.length * 1.001) + 12;
            referenceCounted = byteBufAllocator.heapBuffer(n10);
            this.z.next_out = ((ByteBuf)referenceCounted).array();
            this.z.next_out_index = ((ByteBuf)referenceCounted).arrayOffset() + ((ByteBuf)referenceCounted).writerIndex();
            this.z.avail_out = n10;
            try {
                n4 = this.z.deflate(2);
            }
            finally {
                ((ByteBuf)referenceCounted).skipBytes(this.z.next_in_index - n7);
            }
            if (n4 != 0) {
                throw new CompressionException("compression failure: " + n4);
            }
            int n11 = this.z.next_out_index - n8;
            if (n11 > 0) {
                ((ByteBuf)referenceCounted).writerIndex(((ByteBuf)referenceCounted).writerIndex() + n11);
            }
            bl3 = false;
            ReferenceCounted referenceCounted2 = referenceCounted;
            return referenceCounted2;
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
            if (bl3 && referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator byteBufAllocator, SpdyHeadersFrame spdyHeadersFrame) {
        if (spdyHeadersFrame == null) {
            throw new IllegalArgumentException("frame");
        }
        if (this.finished) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = super.encode(byteBufAllocator, spdyHeadersFrame);
        try {
            if (!byteBuf.isReadable()) {
                ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
                return byteBuf2;
            }
            this.setInput(byteBuf);
            ByteBuf byteBuf3 = this.encode(byteBufAllocator);
            return byteBuf3;
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.z.deflateEnd();
        this.z.next_in = null;
        this.z.next_out = null;
    }
}

