/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import java.nio.ByteOrder;
import java.util.Set;

public class SpdyFrameEncoder {
    private final int version;

    public SpdyFrameEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        this.version = spdyVersion.getVersion();
    }

    private void writeControlFrameHeader(ByteBuf byteBuf, int n4, byte by2, int n7) {
        byteBuf.writeShort(this.version | 0x8000);
        byteBuf.writeShort(n4);
        byteBuf.writeByte(by2);
        byteBuf.writeMedium(n7);
    }

    public ByteBuf encodeDataFrame(ByteBufAllocator byteBufAllocator, int n4, boolean bl3, ByteBuf byteBuf) {
        int n7 = bl3 ? 1 : 0;
        int n8 = byteBuf.readableBytes();
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n8).order(ByteOrder.BIG_ENDIAN);
        byteBuf2.writeInt(n4 & Integer.MAX_VALUE);
        byteBuf2.writeByte(n7);
        byteBuf2.writeMedium(n8);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n8);
        return byteBuf2;
    }

    public ByteBuf encodeSynStreamFrame(ByteBufAllocator byteBufAllocator, int n4, int n7, byte by2, boolean bl3, boolean bl4, ByteBuf byteBuf) {
        byte by3;
        int n8 = byteBuf.readableBytes();
        byte by4 = by3 = bl3 ? (byte)1 : 0;
        if (bl4) {
            by3 = (byte)(by3 | 2);
        }
        int n10 = 10 + n8;
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n10).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf2, 1, by3, n10);
        byteBuf2.writeInt(n4);
        byteBuf2.writeInt(n7);
        byteBuf2.writeShort((by2 & 0xFF) << 13);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n8);
        return byteBuf2;
    }

    public ByteBuf encodeSynReplyFrame(ByteBufAllocator byteBufAllocator, int n4, boolean bl3, ByteBuf byteBuf) {
        int n7 = byteBuf.readableBytes();
        byte by2 = bl3 ? (byte)1 : 0;
        int n8 = 4 + n7;
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf2, 2, by2, n8);
        byteBuf2.writeInt(n4);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n7);
        return byteBuf2;
    }

    public ByteBuf encodeRstStreamFrame(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        byte by2 = 0;
        int n8 = 8;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 3, by2, n8);
        byteBuf.writeInt(n4);
        byteBuf.writeInt(n7);
        return byteBuf;
    }

    public ByteBuf encodeSettingsFrame(ByteBufAllocator byteBufAllocator, SpdySettingsFrame spdySettingsFrame) {
        Set<Integer> set = spdySettingsFrame.ids();
        int n4 = set.size();
        byte by2 = spdySettingsFrame.clearPreviouslyPersistedSettings() ? (byte)1 : 0;
        int n7 = 4 + 8 * n4;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n7).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 4, by2, n7);
        byteBuf.writeInt(n4);
        for (Integer n8 : set) {
            by2 = 0;
            if (spdySettingsFrame.isPersistValue(n8)) {
                by2 = (byte)(by2 | 1);
            }
            if (spdySettingsFrame.isPersisted(n8)) {
                by2 = (byte)(by2 | 2);
            }
            byteBuf.writeByte(by2);
            byteBuf.writeMedium(n8);
            byteBuf.writeInt(spdySettingsFrame.getValue(n8));
        }
        return byteBuf;
    }

    public ByteBuf encodePingFrame(ByteBufAllocator byteBufAllocator, int n4) {
        byte by2 = 0;
        int n7 = 4;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n7).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 6, by2, n7);
        byteBuf.writeInt(n4);
        return byteBuf;
    }

    public ByteBuf encodeGoAwayFrame(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        byte by2 = 0;
        int n8 = 8;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 7, by2, n8);
        byteBuf.writeInt(n4);
        byteBuf.writeInt(n7);
        return byteBuf;
    }

    public ByteBuf encodeHeadersFrame(ByteBufAllocator byteBufAllocator, int n4, boolean bl3, ByteBuf byteBuf) {
        int n7 = byteBuf.readableBytes();
        byte by2 = bl3 ? (byte)1 : 0;
        int n8 = 4 + n7;
        ByteBuf byteBuf2 = byteBufAllocator.ioBuffer(8 + n8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf2, 8, by2, n8);
        byteBuf2.writeInt(n4);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n7);
        return byteBuf2;
    }

    public ByteBuf encodeWindowUpdateFrame(ByteBufAllocator byteBufAllocator, int n4, int n7) {
        byte by2 = 0;
        int n8 = 8;
        ByteBuf byteBuf = byteBufAllocator.ioBuffer(8 + n8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader(byteBuf, 9, by2, n8);
        byteBuf.writeInt(n4);
        byteBuf.writeInt(n7);
        return byteBuf;
    }
}

