/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrameDecoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class SpdyFrameDecoder {
    private final int spdyVersion;
    private final int maxChunkSize;
    private final SpdyFrameDecoderDelegate delegate;
    private SpdyFrameDecoder$State state;
    private byte flags;
    private int length;
    private int streamId;
    private int numSettings;

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate) {
        this(spdyVersion, spdyFrameDecoderDelegate, 8192);
    }

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate, int n4) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        if (spdyFrameDecoderDelegate == null) {
            throw new NullPointerException("delegate");
        }
        ObjectUtil.checkPositive(n4, "maxChunkSize");
        this.spdyVersion = spdyVersion.getVersion();
        this.delegate = spdyFrameDecoderDelegate;
        this.maxChunkSize = n4;
        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
    }

    public void decode(ByteBuf byteBuf) {
        block16: while (true) {
            switch (this.state) {
                case READ_COMMON_HEADER: {
                    int n4;
                    int n7;
                    boolean bl3;
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    int n8 = byteBuf.readerIndex();
                    int n10 = n8 + 4;
                    int n11 = n8 + 5;
                    byteBuf.skipBytes(8);
                    boolean bl4 = bl3 = (byteBuf.getByte(n8) & 0x80) != 0;
                    if (bl3) {
                        n7 = SpdyCodecUtil.getUnsignedShort(byteBuf, n8) & Short.MAX_VALUE;
                        n4 = SpdyCodecUtil.getUnsignedShort(byteBuf, n8 + 2);
                        this.streamId = 0;
                    } else {
                        n7 = this.spdyVersion;
                        n4 = 0;
                        this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, n8);
                    }
                    this.flags = byteBuf.getByte(n10);
                    this.length = SpdyCodecUtil.getUnsignedMedium(byteBuf, n11);
                    if (n7 != this.spdyVersion) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SPDY Version");
                        continue block16;
                    }
                    if (!SpdyFrameDecoder.isValidFrameHeader(this.streamId, n4, this.flags, this.length)) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid Frame Error");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder.getNextState(n4, this.length);
                    continue block16;
                }
                case READ_DATA_FRAME: {
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readDataFrame(this.streamId, SpdyFrameDecoder.hasFlag(this.flags, (byte)1), Unpooled.buffer(0));
                        continue block16;
                    }
                    int n12 = Math.min(this.maxChunkSize, this.length);
                    if (byteBuf.readableBytes() < n12) {
                        return;
                    }
                    ByteBuf byteBuf2 = byteBuf.alloc().buffer(n12);
                    byteBuf2.writeBytes(byteBuf, n12);
                    this.length -= n12;
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    }
                    boolean bl5 = this.length == 0 && SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    this.delegate.readDataFrame(this.streamId, bl5, byteBuf2);
                    continue block16;
                }
                case READ_SYN_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 10) {
                        return;
                    }
                    int n13 = byteBuf.readerIndex();
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, n13);
                    int n14 = SpdyCodecUtil.getUnsignedInt(byteBuf, n13 + 4);
                    byte by2 = (byte)(byteBuf.getByte(n13 + 8) >> 5 & 7);
                    boolean bl5 = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    boolean bl6 = SpdyFrameDecoder.hasFlag(this.flags, (byte)2);
                    byteBuf.skipBytes(10);
                    this.length -= 10;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_STREAM Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readSynStreamFrame(this.streamId, n14, by2, bl5, bl6);
                    continue block16;
                }
                case READ_SYN_REPLY_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    boolean bl5 = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_REPLY Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readSynReplyFrame(this.streamId, bl5);
                    continue block16;
                }
                case READ_RST_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    int n15 = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (this.streamId == 0 || n15 == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid RST_STREAM Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readRstStreamFrame(this.streamId, n15);
                    continue block16;
                }
                case READ_SETTINGS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    boolean bl8 = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    this.numSettings = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if ((this.length & 7) != 0 || this.length >> 3 != this.numSettings) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SETTINGS Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_SETTING;
                    this.delegate.readSettingsFrame(bl8);
                    continue block16;
                }
                case READ_SETTING: {
                    if (this.numSettings == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readSettingsEnd();
                        continue block16;
                    }
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    byte by3 = byteBuf.getByte(byteBuf.readerIndex());
                    int n16 = SpdyCodecUtil.getUnsignedMedium(byteBuf, byteBuf.readerIndex() + 1);
                    int n17 = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    boolean bl9 = SpdyFrameDecoder.hasFlag(by3, (byte)1);
                    boolean bl10 = SpdyFrameDecoder.hasFlag(by3, (byte)2);
                    byteBuf.skipBytes(8);
                    --this.numSettings;
                    this.delegate.readSetting(n16, n17, bl9, bl10);
                    continue block16;
                }
                case READ_PING_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    int n18 = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex());
                    byteBuf.skipBytes(4);
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readPingFrame(n18);
                    continue block16;
                }
                case READ_GOAWAY_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    int n19 = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    int n15 = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readGoAwayFrame(n19, n15);
                    continue block16;
                }
                case READ_HEADERS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    boolean bl5 = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid HEADERS Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readHeadersFrame(this.streamId, bl5);
                    continue block16;
                }
                case READ_WINDOW_UPDATE_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    int n20 = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (n20 == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid WINDOW_UPDATE Frame");
                        continue block16;
                    }
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readWindowUpdateFrame(this.streamId, n20);
                    continue block16;
                }
                case READ_HEADER_BLOCK: {
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readHeaderBlockEnd();
                        continue block16;
                    }
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    int n21 = Math.min(byteBuf.readableBytes(), this.length);
                    ByteBuf byteBuf3 = byteBuf.alloc().buffer(n21);
                    byteBuf3.writeBytes(byteBuf, n21);
                    this.length -= n21;
                    this.delegate.readHeaderBlock(byteBuf3);
                    continue block16;
                }
                case DISCARD_FRAME: {
                    int n22 = Math.min(byteBuf.readableBytes(), this.length);
                    byteBuf.skipBytes(n22);
                    this.length -= n22;
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        continue block16;
                    }
                    return;
                }
                case FRAME_ERROR: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new Error("Shouldn't reach here.");
    }

    private static boolean hasFlag(byte by2, byte by3) {
        return (by2 & by3) != 0;
    }

    private static SpdyFrameDecoder$State getNextState(int n4, int n7) {
        switch (n4) {
            case 0: {
                return SpdyFrameDecoder$State.READ_DATA_FRAME;
            }
            case 1: {
                return SpdyFrameDecoder$State.READ_SYN_STREAM_FRAME;
            }
            case 2: {
                return SpdyFrameDecoder$State.READ_SYN_REPLY_FRAME;
            }
            case 3: {
                return SpdyFrameDecoder$State.READ_RST_STREAM_FRAME;
            }
            case 4: {
                return SpdyFrameDecoder$State.READ_SETTINGS_FRAME;
            }
            case 6: {
                return SpdyFrameDecoder$State.READ_PING_FRAME;
            }
            case 7: {
                return SpdyFrameDecoder$State.READ_GOAWAY_FRAME;
            }
            case 8: {
                return SpdyFrameDecoder$State.READ_HEADERS_FRAME;
            }
            case 9: {
                return SpdyFrameDecoder$State.READ_WINDOW_UPDATE_FRAME;
            }
        }
        if (n7 != 0) {
            return SpdyFrameDecoder$State.DISCARD_FRAME;
        }
        return SpdyFrameDecoder$State.READ_COMMON_HEADER;
    }

    private static boolean isValidFrameHeader(int n4, int n7, byte by2, int n8) {
        switch (n7) {
            case 0: {
                return n4 != 0;
            }
            case 1: {
                return n8 >= 10;
            }
            case 2: {
                return n8 >= 4;
            }
            case 3: {
                return by2 == 0 && n8 == 8;
            }
            case 4: {
                return n8 >= 4;
            }
            case 6: {
                return n8 == 4;
            }
            case 7: {
                return n8 == 8;
            }
            case 8: {
                return n8 >= 4;
            }
            case 9: {
                return n8 == 8;
            }
        }
        return true;
    }
}

