/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.UnsupportedMessageTypeException;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyDataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrameCodec$1;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrameDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyFrameEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaderBlockDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyPingFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyProtocolException;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import java.net.SocketAddress;
import java.util.List;

public class SpdyFrameCodec
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
SpdyFrameDecoderDelegate {
    private static final SpdyProtocolException INVALID_FRAME = new SpdyProtocolException("Received invalid frame");
    private final SpdyFrameDecoder spdyFrameDecoder;
    private final SpdyFrameEncoder spdyFrameEncoder;
    private final SpdyHeaderBlockDecoder spdyHeaderBlockDecoder;
    private final SpdyHeaderBlockEncoder spdyHeaderBlockEncoder;
    private SpdyHeadersFrame spdyHeadersFrame;
    private SpdySettingsFrame spdySettingsFrame;
    private ChannelHandlerContext ctx;
    private boolean read;
    private final boolean validateHeaders;

    public SpdyFrameCodec(SpdyVersion spdyVersion) {
        this(spdyVersion, true);
    }

    public SpdyFrameCodec(SpdyVersion spdyVersion, boolean bl3) {
        this(spdyVersion, 8192, 16384, 6, 15, 8, bl3);
    }

    public SpdyFrameCodec(SpdyVersion spdyVersion, int n4, int n7, int n8, int n10, int n11) {
        this(spdyVersion, n4, n7, n8, n10, n11, true);
    }

    public SpdyFrameCodec(SpdyVersion spdyVersion, int n4, int n7, int n8, int n10, int n11, boolean bl3) {
        this(spdyVersion, n4, SpdyHeaderBlockDecoder.newInstance(spdyVersion, n7), SpdyHeaderBlockEncoder.newInstance(spdyVersion, n8, n10, n11), bl3);
    }

    protected SpdyFrameCodec(SpdyVersion spdyVersion, int n4, SpdyHeaderBlockDecoder spdyHeaderBlockDecoder, SpdyHeaderBlockEncoder spdyHeaderBlockEncoder, boolean bl3) {
        this.spdyFrameDecoder = new SpdyFrameDecoder(spdyVersion, this, n4);
        this.spdyFrameEncoder = new SpdyFrameEncoder(spdyVersion);
        this.spdyHeaderBlockDecoder = spdyHeaderBlockDecoder;
        this.spdyHeaderBlockEncoder = spdyHeaderBlockEncoder;
        this.validateHeaders = bl3;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        this.ctx = channelHandlerContext;
        channelHandlerContext.channel().closeFuture().addListener(new SpdyFrameCodec$1(this));
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.spdyFrameDecoder.decode(byteBuf);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (!this.read && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        this.read = false;
        super.channelReadComplete(channelHandlerContext);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeDataFrame(channelHandlerContext.alloc(), spdyDataFrame.streamId(), spdyDataFrame.isLast(), spdyDataFrame.content());
            spdyDataFrame.release();
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdySynStreamFrame) {
            ByteBuf byteBuf;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            ByteBuf byteBuf2 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), spdySynStreamFrame);
            try {
                byteBuf = this.spdyFrameEncoder.encodeSynStreamFrame(channelHandlerContext.alloc(), spdySynStreamFrame.streamId(), spdySynStreamFrame.associatedStreamId(), spdySynStreamFrame.priority(), spdySynStreamFrame.isLast(), spdySynStreamFrame.isUnidirectional(), byteBuf2);
            }
            finally {
                byteBuf2.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdySynReplyFrame) {
            ByteBuf byteBuf;
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            ByteBuf byteBuf3 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), spdySynReplyFrame);
            try {
                byteBuf = this.spdyFrameEncoder.encodeSynReplyFrame(channelHandlerContext.alloc(), spdySynReplyFrame.streamId(), spdySynReplyFrame.isLast(), byteBuf3);
            }
            finally {
                byteBuf3.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeRstStreamFrame(channelHandlerContext.alloc(), spdyRstStreamFrame.streamId(), spdyRstStreamFrame.status().code());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeSettingsFrame(channelHandlerContext.alloc(), spdySettingsFrame);
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodePingFrame(channelHandlerContext.alloc(), spdyPingFrame.id());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyGoAwayFrame) {
            SpdyGoAwayFrame spdyGoAwayFrame = (SpdyGoAwayFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeGoAwayFrame(channelHandlerContext.alloc(), spdyGoAwayFrame.lastGoodStreamId(), spdyGoAwayFrame.status().code());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyHeadersFrame) {
            ByteBuf byteBuf;
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
            ByteBuf byteBuf4 = this.spdyHeaderBlockEncoder.encode(channelHandlerContext.alloc(), spdyHeadersFrame);
            try {
                byteBuf = this.spdyFrameEncoder.encodeHeadersFrame(channelHandlerContext.alloc(), spdyHeadersFrame.streamId(), spdyHeadersFrame.isLast(), byteBuf4);
            }
            finally {
                byteBuf4.release();
            }
            channelHandlerContext.write(byteBuf, channelPromise);
        } else if (object instanceof SpdyWindowUpdateFrame) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)object;
            ByteBuf byteBuf = this.spdyFrameEncoder.encodeWindowUpdateFrame(channelHandlerContext.alloc(), spdyWindowUpdateFrame.streamId(), spdyWindowUpdateFrame.deltaWindowSize());
            channelHandlerContext.write(byteBuf, channelPromise);
        } else {
            throw new UnsupportedMessageTypeException(object, new Class[0]);
        }
    }

    @Override
    public void readDataFrame(int n4, boolean bl3, ByteBuf byteBuf) {
        this.read = true;
        DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n4, byteBuf);
        defaultSpdyDataFrame.setLast(bl3);
        this.ctx.fireChannelRead(defaultSpdyDataFrame);
    }

    @Override
    public void readSynStreamFrame(int n4, int n7, byte by2, boolean bl3, boolean bl4) {
        DefaultSpdySynStreamFrame defaultSpdySynStreamFrame = new DefaultSpdySynStreamFrame(n4, n7, by2, this.validateHeaders);
        defaultSpdySynStreamFrame.setLast(bl3);
        defaultSpdySynStreamFrame.setUnidirectional(bl4);
        this.spdyHeadersFrame = defaultSpdySynStreamFrame;
    }

    @Override
    public void readSynReplyFrame(int n4, boolean bl3) {
        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n4, this.validateHeaders);
        defaultSpdySynReplyFrame.setLast(bl3);
        this.spdyHeadersFrame = defaultSpdySynReplyFrame;
    }

    @Override
    public void readRstStreamFrame(int n4, int n7) {
        this.read = true;
        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n4, n7);
        this.ctx.fireChannelRead(defaultSpdyRstStreamFrame);
    }

    @Override
    public void readSettingsFrame(boolean bl3) {
        this.read = true;
        this.spdySettingsFrame = new DefaultSpdySettingsFrame();
        this.spdySettingsFrame.setClearPreviouslyPersistedSettings(bl3);
    }

    @Override
    public void readSetting(int n4, int n7, boolean bl3, boolean bl4) {
        this.spdySettingsFrame.setValue(n4, n7, bl3, bl4);
    }

    @Override
    public void readSettingsEnd() {
        this.read = true;
        SpdySettingsFrame spdySettingsFrame = this.spdySettingsFrame;
        this.spdySettingsFrame = null;
        this.ctx.fireChannelRead(spdySettingsFrame);
    }

    @Override
    public void readPingFrame(int n4) {
        this.read = true;
        DefaultSpdyPingFrame defaultSpdyPingFrame = new DefaultSpdyPingFrame(n4);
        this.ctx.fireChannelRead(defaultSpdyPingFrame);
    }

    @Override
    public void readGoAwayFrame(int n4, int n7) {
        this.read = true;
        DefaultSpdyGoAwayFrame defaultSpdyGoAwayFrame = new DefaultSpdyGoAwayFrame(n4, n7);
        this.ctx.fireChannelRead(defaultSpdyGoAwayFrame);
    }

    @Override
    public void readHeadersFrame(int n4, boolean bl3) {
        this.spdyHeadersFrame = new DefaultSpdyHeadersFrame(n4, this.validateHeaders);
        this.spdyHeadersFrame.setLast(bl3);
    }

    @Override
    public void readWindowUpdateFrame(int n4, int n7) {
        this.read = true;
        DefaultSpdyWindowUpdateFrame defaultSpdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(n4, n7);
        this.ctx.fireChannelRead(defaultSpdyWindowUpdateFrame);
    }

    @Override
    public void readHeaderBlock(ByteBuf byteBuf) {
        try {
            this.spdyHeaderBlockDecoder.decode(this.ctx.alloc(), byteBuf, this.spdyHeadersFrame);
        }
        catch (Exception exception) {
            this.ctx.fireExceptionCaught(exception);
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void readHeaderBlockEnd() {
        SpdyHeadersFrame spdyHeadersFrame = null;
        try {
            this.spdyHeaderBlockDecoder.endHeaderBlock(this.spdyHeadersFrame);
            spdyHeadersFrame = this.spdyHeadersFrame;
            this.spdyHeadersFrame = null;
        }
        catch (Exception exception) {
            this.ctx.fireExceptionCaught(exception);
        }
        if (spdyHeadersFrame != null) {
            this.read = true;
            this.ctx.fireChannelRead(spdyHeadersFrame);
        }
    }

    @Override
    public void readFrameError(String string) {
        this.ctx.fireExceptionCaught(INVALID_FRAME);
    }

    static /* synthetic */ SpdyHeaderBlockDecoder access$000(SpdyFrameCodec spdyFrameCodec) {
        return spdyFrameCodec.spdyHeaderBlockDecoder;
    }

    static /* synthetic */ SpdyHeaderBlockEncoder access$100(SpdyFrameCodec spdyFrameCodec) {
        return spdyFrameCodec.spdyHeaderBlockEncoder;
    }
}

