/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.spdy;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.spdy.SpdyDataFrame;
import io.grpc.netty.shaded.io.netty.util.IllegalReferenceCountException;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
extends DefaultSpdyStreamFrame
implements SpdyDataFrame {
    private final ByteBuf data;

    public DefaultSpdyDataFrame(int n4) {
        this(n4, Unpooled.buffer(0));
    }

    public DefaultSpdyDataFrame(int n4, ByteBuf byteBuf) {
        super(n4);
        if (byteBuf == null) {
            throw new NullPointerException("data");
        }
        this.data = DefaultSpdyDataFrame.validate(byteBuf);
    }

    private static ByteBuf validate(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        return byteBuf;
    }

    @Override
    public SpdyDataFrame setStreamId(int n4) {
        super.setStreamId(n4);
        return this;
    }

    @Override
    public SpdyDataFrame setLast(boolean bl3) {
        super.setLast(bl3);
        return this;
    }

    @Override
    public ByteBuf content() {
        if (this.data.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.data.refCnt());
        }
        return this.data;
    }

    @Override
    public SpdyDataFrame copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public SpdyDataFrame duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public SpdyDataFrame retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public SpdyDataFrame replace(ByteBuf byteBuf) {
        DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(this.streamId(), byteBuf);
        defaultSpdyDataFrame.setLast(this.isLast());
        return defaultSpdyDataFrame;
    }

    @Override
    public int refCnt() {
        return this.data.refCnt();
    }

    @Override
    public SpdyDataFrame retain() {
        this.data.retain();
        return this;
    }

    @Override
    public SpdyDataFrame retain(int n4) {
        this.data.retain(n4);
        return this;
    }

    @Override
    public SpdyDataFrame touch() {
        this.data.touch();
        return this;
    }

    @Override
    public SpdyDataFrame touch(Object object) {
        this.data.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.data.release();
    }

    @Override
    public boolean release(int n4) {
        return this.data.release(n4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(last: ").append(this.isLast()).append(')').append(StringUtil.NEWLINE).append("--> Stream-ID = ").append(this.streamId()).append(StringUtil.NEWLINE).append("--> Size = ");
        if (this.refCnt() == 0) {
            stringBuilder.append("(freed)");
        } else {
            stringBuilder.append(this.content().readableBytes());
        }
        return stringBuilder.toString();
    }
}

