/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.EncoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5CommandResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5InitialResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5Message;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5PasswordAuthResponse;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

@ChannelHandler$Sharable
public class Socks5ServerEncoder
extends MessageToByteEncoder<Socks5Message> {
    public static final Socks5ServerEncoder DEFAULT = new Socks5ServerEncoder(Socks5AddressEncoder.DEFAULT);
    private final Socks5AddressEncoder addressEncoder;

    protected Socks5ServerEncoder() {
        this(Socks5AddressEncoder.DEFAULT);
    }

    public Socks5ServerEncoder(Socks5AddressEncoder socks5AddressEncoder) {
        if (socks5AddressEncoder == null) {
            throw new NullPointerException("addressEncoder");
        }
        this.addressEncoder = socks5AddressEncoder;
    }

    protected final Socks5AddressEncoder addressEncoder() {
        return this.addressEncoder;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, Socks5Message socks5Message, ByteBuf byteBuf) {
        if (socks5Message instanceof Socks5InitialResponse) {
            Socks5ServerEncoder.encodeAuthMethodResponse((Socks5InitialResponse)socks5Message, byteBuf);
        } else if (socks5Message instanceof Socks5PasswordAuthResponse) {
            Socks5ServerEncoder.encodePasswordAuthResponse((Socks5PasswordAuthResponse)socks5Message, byteBuf);
        } else if (socks5Message instanceof Socks5CommandResponse) {
            this.encodeCommandResponse((Socks5CommandResponse)socks5Message, byteBuf);
        } else {
            throw new EncoderException("unsupported message type: " + StringUtil.simpleClassName(socks5Message));
        }
    }

    private static void encodeAuthMethodResponse(Socks5InitialResponse socks5InitialResponse, ByteBuf byteBuf) {
        byteBuf.writeByte(socks5InitialResponse.version().byteValue());
        byteBuf.writeByte(socks5InitialResponse.authMethod().byteValue());
    }

    private static void encodePasswordAuthResponse(Socks5PasswordAuthResponse socks5PasswordAuthResponse, ByteBuf byteBuf) {
        byteBuf.writeByte(1);
        byteBuf.writeByte(socks5PasswordAuthResponse.status().byteValue());
    }

    private void encodeCommandResponse(Socks5CommandResponse socks5CommandResponse, ByteBuf byteBuf) {
        byteBuf.writeByte(socks5CommandResponse.version().byteValue());
        byteBuf.writeByte(socks5CommandResponse.status().byteValue());
        byteBuf.writeByte(0);
        Socks5AddressType socks5AddressType = socks5CommandResponse.bndAddrType();
        byteBuf.writeByte(socks5AddressType.byteValue());
        this.addressEncoder.encodeAddress(socks5AddressType, socks5CommandResponse.bndAddr(), byteBuf);
        byteBuf.writeShort(socks5CommandResponse.bndPort());
    }
}

