/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder$State;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import java.util.List;

public class Socks5PasswordAuthRequestDecoder
extends ReplayingDecoder<Socks5PasswordAuthRequestDecoder$State> {
    public Socks5PasswordAuthRequestDecoder() {
        super(Socks5PasswordAuthRequestDecoder$State.INIT);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks5PasswordAuthRequestDecoder$State)((Object)this.state())) {
                case INIT: {
                    int n4 = byteBuf.readerIndex();
                    byte by2 = byteBuf.getByte(n4);
                    if (by2 != 1) {
                        throw new DecoderException("unsupported subnegotiation version: " + by2 + " (expected: 1)");
                    }
                    short s11 = byteBuf.getUnsignedByte(n4 + 1);
                    short s12 = byteBuf.getUnsignedByte(n4 + 2 + s11);
                    int n7 = s11 + s12 + 3;
                    byteBuf.skipBytes(n7);
                    list.add(new DefaultSocks5PasswordAuthRequest(byteBuf.toString(n4 + 2, s11, CharsetUtil.US_ASCII), byteBuf.toString(n4 + 3 + s11, s12, CharsetUtil.US_ASCII)));
                    this.checkpoint(Socks5PasswordAuthRequestDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n4 = this.actualReadableBytes();
                    if (n4 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n4));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        this.checkpoint(Socks5PasswordAuthRequestDecoder$State.FAILURE);
        DefaultSocks5PasswordAuthRequest defaultSocks5PasswordAuthRequest = new DefaultSocks5PasswordAuthRequest("", "");
        defaultSocks5PasswordAuthRequest.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks5PasswordAuthRequest);
    }
}

