/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.SocksVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.DefaultSocks5InitialRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder$State;
import java.util.List;

public class Socks5InitialRequestDecoder
extends ReplayingDecoder<Socks5InitialRequestDecoder$State> {
    public Socks5InitialRequestDecoder() {
        super(Socks5InitialRequestDecoder$State.INIT);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks5InitialRequestDecoder$State)((Object)this.state())) {
                case INIT: {
                    int n4 = byteBuf.readByte();
                    if (n4 != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + n4 + " (expected: " + SocksVersion.SOCKS5.byteValue() + ')');
                    }
                    int n7 = byteBuf.readUnsignedByte();
                    if (this.actualReadableBytes() < n7) break;
                    Socks5AuthMethod[] socks5AuthMethodArray = new Socks5AuthMethod[n7];
                    for (int i3 = 0; i3 < n7; ++i3) {
                        socks5AuthMethodArray[i3] = Socks5AuthMethod.valueOf(byteBuf.readByte());
                    }
                    list.add(new DefaultSocks5InitialRequest(socks5AuthMethodArray));
                    this.checkpoint(Socks5InitialRequestDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n4 = this.actualReadableBytes();
                    if (n4 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n4));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        this.checkpoint(Socks5InitialRequestDecoder$State.FAILURE);
        DefaultSocks5InitialRequest defaultSocks5InitialRequest = new DefaultSocks5InitialRequest(Socks5AuthMethod.NO_AUTH);
        defaultSocks5InitialRequest.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks5InitialRequest);
    }
}

