/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.SocksVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.DefaultSocks5CommandRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5CommandType;
import java.util.List;

public class Socks5CommandRequestDecoder
extends ReplayingDecoder<Socks5CommandRequestDecoder$State> {
    private final Socks5AddressDecoder addressDecoder;

    public Socks5CommandRequestDecoder() {
        this(Socks5AddressDecoder.DEFAULT);
    }

    public Socks5CommandRequestDecoder(Socks5AddressDecoder socks5AddressDecoder) {
        super(Socks5CommandRequestDecoder$State.INIT);
        if (socks5AddressDecoder == null) {
            throw new NullPointerException("addressDecoder");
        }
        this.addressDecoder = socks5AddressDecoder;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks5CommandRequestDecoder$State)((Object)this.state())) {
                case INIT: {
                    int n4 = byteBuf.readByte();
                    if (n4 != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + n4 + " (expected: " + SocksVersion.SOCKS5.byteValue() + ')');
                    }
                    Socks5CommandType socks5CommandType = Socks5CommandType.valueOf(byteBuf.readByte());
                    byteBuf.skipBytes(1);
                    Socks5AddressType socks5AddressType = Socks5AddressType.valueOf(byteBuf.readByte());
                    String string = this.addressDecoder.decodeAddress(socks5AddressType, byteBuf);
                    int n7 = byteBuf.readUnsignedShort();
                    list.add(new DefaultSocks5CommandRequest(socks5CommandType, socks5AddressType, string, n7));
                    this.checkpoint(Socks5CommandRequestDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n4 = this.actualReadableBytes();
                    if (n4 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n4));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        this.checkpoint(Socks5CommandRequestDecoder$State.FAILURE);
        DefaultSocks5CommandRequest defaultSocks5CommandRequest = new DefaultSocks5CommandRequest(Socks5CommandType.CONNECT, Socks5AddressType.IPv4, "0.0.0.0", 1);
        defaultSocks5CommandRequest.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks5CommandRequest);
    }
}

