/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.NetUtil;

final class Socks5AddressDecoder$1
implements Socks5AddressDecoder {
    private static final int IPv6_LEN = 16;

    Socks5AddressDecoder$1() {
    }

    @Override
    public String decodeAddress(Socks5AddressType socks5AddressType, ByteBuf byteBuf) {
        if (socks5AddressType == Socks5AddressType.IPv4) {
            return NetUtil.intToIpAddress(byteBuf.readInt());
        }
        if (socks5AddressType == Socks5AddressType.DOMAIN) {
            short s11 = byteBuf.readUnsignedByte();
            String string = byteBuf.toString(byteBuf.readerIndex(), s11, CharsetUtil.US_ASCII);
            byteBuf.skipBytes(s11);
            return string;
        }
        if (socks5AddressType == Socks5AddressType.IPv6) {
            if (byteBuf.hasArray()) {
                int n4 = byteBuf.readerIndex();
                byteBuf.readerIndex(n4 + 16);
                return NetUtil.bytesToIpAddress(byteBuf.array(), byteBuf.arrayOffset() + n4, 16);
            }
            byte[] byArray = new byte[16];
            byteBuf.readBytes(byArray);
            return NetUtil.bytesToIpAddress(byArray);
        }
        throw new DecoderException("unsupported address type: " + (socks5AddressType.byteValue() & 0xFF));
    }
}

