/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.SocksVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.DefaultSocks4CommandRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.Socks4CommandType;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.Socks4ServerDecoder$State;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.NetUtil;
import java.util.List;

public class Socks4ServerDecoder
extends ReplayingDecoder<Socks4ServerDecoder$State> {
    private static final int MAX_FIELD_LENGTH = 255;
    private Socks4CommandType type;
    private String dstAddr;
    private int dstPort;
    private String userId;

    public Socks4ServerDecoder() {
        super(Socks4ServerDecoder$State.START);
        this.setSingleDecode(true);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks4ServerDecoder$State)((Object)this.state())) {
                case START: {
                    int n4 = byteBuf.readUnsignedByte();
                    if (n4 != SocksVersion.SOCKS4a.byteValue()) {
                        throw new DecoderException("unsupported protocol version: " + n4);
                    }
                    this.type = Socks4CommandType.valueOf(byteBuf.readByte());
                    this.dstPort = byteBuf.readUnsignedShort();
                    this.dstAddr = NetUtil.intToIpAddress(byteBuf.readInt());
                    this.checkpoint(Socks4ServerDecoder$State.READ_USERID);
                }
                case READ_USERID: {
                    this.userId = Socks4ServerDecoder.readString("userid", byteBuf);
                    this.checkpoint(Socks4ServerDecoder$State.READ_DOMAIN);
                }
                case READ_DOMAIN: {
                    if (!"0.0.0.0".equals(this.dstAddr) && this.dstAddr.startsWith("0.0.0.")) {
                        this.dstAddr = Socks4ServerDecoder.readString("dstAddr", byteBuf);
                    }
                    list.add(new DefaultSocks4CommandRequest(this.type, this.dstAddr, this.dstPort, this.userId));
                    this.checkpoint(Socks4ServerDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n4 = this.actualReadableBytes();
                    if (n4 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n4));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        DefaultSocks4CommandRequest defaultSocks4CommandRequest = new DefaultSocks4CommandRequest(this.type != null ? this.type : Socks4CommandType.CONNECT, this.dstAddr != null ? this.dstAddr : "", this.dstPort != 0 ? this.dstPort : 65535, this.userId != null ? this.userId : "");
        defaultSocks4CommandRequest.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks4CommandRequest);
        this.checkpoint(Socks4ServerDecoder$State.FAILURE);
    }

    private static String readString(String string, ByteBuf byteBuf) {
        int n4 = byteBuf.bytesBefore(256, (byte)0);
        if (n4 < 0) {
            throw new DecoderException("field '" + string + "' longer than " + 255 + " chars");
        }
        String string2 = byteBuf.readSlice(n4).toString(CharsetUtil.US_ASCII);
        byteBuf.skipBytes(1);
        return string2;
    }
}

