/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.Socks4ClientDecoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import io.grpc.netty.shaded.io.netty.util.NetUtil;
import java.util.List;

public class Socks4ClientDecoder
extends ReplayingDecoder<Socks4ClientDecoder$State> {
    public Socks4ClientDecoder() {
        super(Socks4ClientDecoder$State.START);
        this.setSingleDecode(true);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch ((Socks4ClientDecoder$State)((Object)this.state())) {
                case START: {
                    int n4 = byteBuf.readUnsignedByte();
                    if (n4 != 0) {
                        throw new DecoderException("unsupported reply version: " + n4 + " (expected: 0)");
                    }
                    Socks4CommandStatus socks4CommandStatus = Socks4CommandStatus.valueOf(byteBuf.readByte());
                    int n7 = byteBuf.readUnsignedShort();
                    String string = NetUtil.intToIpAddress(byteBuf.readInt());
                    list.add(new DefaultSocks4CommandResponse(socks4CommandStatus, string, n7));
                    this.checkpoint(Socks4ClientDecoder$State.SUCCESS);
                }
                case SUCCESS: {
                    int n4 = this.actualReadableBytes();
                    if (n4 <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n4));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Exception exception) {
        if (!(exception instanceof DecoderException)) {
            exception = new DecoderException(exception);
        }
        DefaultSocks4CommandResponse defaultSocks4CommandResponse = new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED);
        defaultSocks4CommandResponse.setDecoderResult(DecoderResult.failure(exception));
        list.add(defaultSocks4CommandResponse);
        this.checkpoint(Socks4ClientDecoder$State.FAILURE);
    }
}

