/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socksx;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.SocksVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v4.Socks4ServerEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class SocksPortUnificationServerHandler
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocksPortUnificationServerHandler.class);
    private final Socks5ServerEncoder socks5encoder;

    public SocksPortUnificationServerHandler() {
        this(Socks5ServerEncoder.DEFAULT);
    }

    public SocksPortUnificationServerHandler(Socks5ServerEncoder socks5ServerEncoder) {
        if (socks5ServerEncoder == null) {
            throw new NullPointerException("socks5encoder");
        }
        this.socks5encoder = socks5ServerEncoder;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n4 = byteBuf.readerIndex();
        if (byteBuf.writerIndex() == n4) {
            return;
        }
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        byte by2 = byteBuf.getByte(n4);
        SocksVersion socksVersion = SocksVersion.valueOf(by2);
        switch (socksVersion) {
            case SOCKS4a: {
                SocksPortUnificationServerHandler.logKnownVersion(channelHandlerContext, socksVersion);
                channelPipeline.addAfter(channelHandlerContext.name(), null, Socks4ServerEncoder.INSTANCE);
                channelPipeline.addAfter(channelHandlerContext.name(), null, new Socks4ServerDecoder());
                break;
            }
            case SOCKS5: {
                SocksPortUnificationServerHandler.logKnownVersion(channelHandlerContext, socksVersion);
                channelPipeline.addAfter(channelHandlerContext.name(), null, this.socks5encoder);
                channelPipeline.addAfter(channelHandlerContext.name(), null, new Socks5InitialRequestDecoder());
                break;
            }
            default: {
                SocksPortUnificationServerHandler.logUnknownVersion(channelHandlerContext, by2);
                byteBuf.skipBytes(byteBuf.readableBytes());
                channelHandlerContext.close();
                return;
            }
        }
        channelPipeline.remove(this);
    }

    private static void logKnownVersion(ChannelHandlerContext channelHandlerContext, SocksVersion socksVersion) {
        logger.debug("{} Protocol version: {}({})", (Object)channelHandlerContext.channel(), (Object)socksVersion);
    }

    private static void logUnknownVersion(ChannelHandlerContext channelHandlerContext, byte by2) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} Unknown protocol version: {}", (Object)channelHandlerContext.channel(), (Object)(by2 & 0xFF));
        }
    }
}

