/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socks;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksAuthScheme;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksCommonUtils;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksInitRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksInitRequestDecoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksProtocolVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SocksInitRequestDecoder
extends ReplayingDecoder<SocksInitRequestDecoder$State> {
    public SocksInitRequestDecoder() {
        super(SocksInitRequestDecoder$State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        switch ((SocksInitRequestDecoder$State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                if (byteBuf.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    list.add(SocksCommonUtils.UNKNOWN_SOCKS_REQUEST);
                    break;
                }
                this.checkpoint(SocksInitRequestDecoder$State.READ_AUTH_SCHEMES);
            }
            case READ_AUTH_SCHEMES: {
                List<SocksAuthScheme> list2;
                int n4 = byteBuf.readByte();
                if (n4 > 0) {
                    list2 = new ArrayList(n4);
                    for (int i3 = 0; i3 < n4; ++i3) {
                        list2.add(SocksAuthScheme.valueOf(byteBuf.readByte()));
                    }
                } else {
                    list2 = Collections.emptyList();
                }
                list.add(new SocksInitRequest(list2));
                break;
            }
            default: {
                throw new Error();
            }
        }
        channelHandlerContext.pipeline().remove(this);
    }
}

