/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socks;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.UnknownSocksRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.UnknownSocksResponse;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;

final class SocksCommonUtils {
    public static final SocksRequest UNKNOWN_SOCKS_REQUEST = new UnknownSocksRequest();
    public static final SocksResponse UNKNOWN_SOCKS_RESPONSE = new UnknownSocksResponse();
    private static final char ipv6hextetSeparator = ':';

    private SocksCommonUtils() {
    }

    public static String ipv6toStr(byte[] byArray) {
        assert (byArray.length == 16);
        StringBuilder stringBuilder = new StringBuilder(39);
        SocksCommonUtils.ipv6toStr(stringBuilder, byArray, 0, 8);
        return stringBuilder.toString();
    }

    private static void ipv6toStr(StringBuilder stringBuilder, byte[] byArray, int n4, int n7) {
        int n8;
        --n7;
        for (n8 = n4; n8 < n7; ++n8) {
            SocksCommonUtils.appendHextet(stringBuilder, byArray, n8);
            stringBuilder.append(':');
        }
        SocksCommonUtils.appendHextet(stringBuilder, byArray, n8);
    }

    private static void appendHextet(StringBuilder stringBuilder, byte[] byArray, int n4) {
        StringUtil.toHexString(stringBuilder, byArray, n4 << 1, 2);
    }

    static String readUsAscii(ByteBuf byteBuf, int n4) {
        String string = byteBuf.toString(byteBuf.readerIndex(), n4, CharsetUtil.US_ASCII);
        byteBuf.skipBytes(n4);
        return string;
    }
}

