/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.socks;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksAddressType;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksCmdType;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksRequestType;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.NetUtil;
import java.net.IDN;

public final class SocksCmdRequest
extends SocksRequest {
    private final SocksCmdType cmdType;
    private final SocksAddressType addressType;
    private final String host;
    private final int port;

    public SocksCmdRequest(SocksCmdType socksCmdType, SocksAddressType socksAddressType, String string, int n4) {
        super(SocksRequestType.CMD);
        if (socksCmdType == null) {
            throw new NullPointerException("cmdType");
        }
        if (socksAddressType == null) {
            throw new NullPointerException("addressType");
        }
        if (string == null) {
            throw new NullPointerException("host");
        }
        switch (socksAddressType) {
            case IPv4: {
                if (NetUtil.isValidIpV4Address(string)) break;
                throw new IllegalArgumentException(string + " is not a valid IPv4 address");
            }
            case DOMAIN: {
                String string2 = IDN.toASCII(string);
                if (string2.length() > 255) {
                    throw new IllegalArgumentException(string + " IDN: " + string2 + " exceeds 255 char limit");
                }
                string = string2;
                break;
            }
            case IPv6: {
                if (NetUtil.isValidIpV6Address(string)) break;
                throw new IllegalArgumentException(string + " is not a valid IPv6 address");
            }
        }
        if (n4 <= 0 || n4 >= 65536) {
            throw new IllegalArgumentException(n4 + " is not in bounds 0 < x < 65536");
        }
        this.cmdType = socksCmdType;
        this.addressType = socksAddressType;
        this.host = string;
        this.port = n4;
    }

    public SocksCmdType cmdType() {
        return this.cmdType;
    }

    public SocksAddressType addressType() {
        return this.addressType;
    }

    public String host() {
        return this.addressType == SocksAddressType.DOMAIN ? IDN.toUnicode(this.host) : this.host;
    }

    public int port() {
        return this.port;
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.protocolVersion().byteValue());
        byteBuf.writeByte(this.cmdType.byteValue());
        byteBuf.writeByte(0);
        byteBuf.writeByte(this.addressType.byteValue());
        switch (this.addressType) {
            case IPv4: {
                byteBuf.writeBytes(NetUtil.createByteArrayFromIpAddressString(this.host));
                byteBuf.writeShort(this.port);
                break;
            }
            case DOMAIN: {
                byteBuf.writeByte(this.host.length());
                byteBuf.writeCharSequence(this.host, CharsetUtil.US_ASCII);
                byteBuf.writeShort(this.port);
                break;
            }
            case IPv6: {
                byteBuf.writeBytes(NetUtil.createByteArrayFromIpAddressString(this.host));
                byteBuf.writeShort(this.port);
            }
        }
    }
}

