/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.serialization;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufOutputStream;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.serialization.CompactObjectOutputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class ObjectEncoderOutputStream
extends OutputStream
implements ObjectOutput {
    private final DataOutputStream out;
    private final int estimatedLength;

    public ObjectEncoderOutputStream(OutputStream outputStream) {
        this(outputStream, 512);
    }

    public ObjectEncoderOutputStream(OutputStream outputStream, int n4) {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("estimatedLength: " + n4);
        }
        this.out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.estimatedLength = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object object) {
        ByteBuf byteBuf = Unpooled.buffer(this.estimatedLength);
        try {
            try (CompactObjectOutputStream compactObjectOutputStream = new CompactObjectOutputStream(new ByteBufOutputStream(byteBuf));){
                compactObjectOutputStream.writeObject(object);
                compactObjectOutputStream.flush();
            }
            int n4 = byteBuf.readableBytes();
            this.writeInt(n4);
            byteBuf.getBytes(0, this, n4);
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void write(int n4) {
        this.out.write(n4);
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    public final int size() {
        return this.out.size();
    }

    @Override
    public void write(byte[] byArray, int n4, int n7) {
        this.out.write(byArray, n4, n7);
    }

    @Override
    public void write(byte[] byArray) {
        this.out.write(byArray);
    }

    @Override
    public final void writeBoolean(boolean bl3) {
        this.out.writeBoolean(bl3);
    }

    @Override
    public final void writeByte(int n4) {
        this.out.writeByte(n4);
    }

    @Override
    public final void writeBytes(String string) {
        this.out.writeBytes(string);
    }

    @Override
    public final void writeChar(int n4) {
        this.out.writeChar(n4);
    }

    @Override
    public final void writeChars(String string) {
        this.out.writeChars(string);
    }

    @Override
    public final void writeDouble(double d8) {
        this.out.writeDouble(d8);
    }

    @Override
    public final void writeFloat(float f8) {
        this.out.writeFloat(f8);
    }

    @Override
    public final void writeInt(int n4) {
        this.out.writeInt(n4);
    }

    @Override
    public final void writeLong(long l2) {
        this.out.writeLong(l2);
    }

    @Override
    public final void writeShort(int n4) {
        this.out.writeShort(n4);
    }

    @Override
    public final void writeUTF(String string) {
        this.out.writeUTF(string);
    }
}

