/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.serialization;

import io.grpc.netty.shaded.io.netty.handler.codec.serialization.ClassResolver;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

class CompactObjectInputStream
extends ObjectInputStream {
    private final ClassResolver classResolver;

    CompactObjectInputStream(InputStream inputStream, ClassResolver classResolver) {
        super(inputStream);
        this.classResolver = classResolver;
    }

    @Override
    protected void readStreamHeader() {
        int n4 = this.readByte() & 0xFF;
        if (n4 != 5) {
            throw new StreamCorruptedException("Unsupported version: " + n4);
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() {
        int n4 = this.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        switch (n4) {
            case 0: {
                return super.readClassDescriptor();
            }
            case 1: {
                String string = this.readUTF();
                Class<?> clazz = this.classResolver.resolve(string);
                return ObjectStreamClass.lookupAny(clazz);
            }
        }
        throw new StreamCorruptedException("Unexpected class descriptor type: " + n4);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
        Class<?> clazz;
        try {
            clazz = this.classResolver.resolve(objectStreamClass.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = super.resolveClass(objectStreamClass);
        }
        return clazz;
    }
}

