/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.protobuf;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler$Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4 = byteBuf.readableBytes();
        int n7 = ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size(n4);
        byteBuf2.ensureWritable(n7 + n4);
        ProtobufVarint32LengthFieldPrepender.writeRawVarint32(byteBuf2, n4);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
    }

    static void writeRawVarint32(ByteBuf byteBuf, int n4) {
        while (true) {
            if ((n4 & 0xFFFFFF80) == 0) {
                byteBuf.writeByte(n4);
                return;
            }
            byteBuf.writeByte(n4 & 0x7F | 0x80);
            n4 >>>= 7;
        }
    }

    static int computeRawVarint32Size(int n4) {
        if ((n4 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n4 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n4 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n4 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }
}

