/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.protobuf;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.CorruptedFrameException;
import java.util.List;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        byteBuf.markReaderIndex();
        int n4 = byteBuf.readerIndex();
        int n7 = ProtobufVarint32FrameDecoder.readRawVarint32(byteBuf);
        if (n4 == byteBuf.readerIndex()) {
            return;
        }
        if (n7 < 0) {
            throw new CorruptedFrameException("negative length: " + n7);
        }
        if (byteBuf.readableBytes() < n7) {
            byteBuf.resetReaderIndex();
        } else {
            list.add(byteBuf.readRetainedSlice(n7));
        }
    }

    private static int readRawVarint32(ByteBuf byteBuf) {
        if (!byteBuf.isReadable()) {
            return 0;
        }
        byteBuf.markReaderIndex();
        byte by2 = byteBuf.readByte();
        if (by2 >= 0) {
            return by2;
        }
        int n4 = by2 & 0x7F;
        if (!byteBuf.isReadable()) {
            byteBuf.resetReaderIndex();
            return 0;
        }
        by2 = byteBuf.readByte();
        if (by2 >= 0) {
            n4 |= by2 << 7;
        } else {
            n4 |= (by2 & 0x7F) << 7;
            if (!byteBuf.isReadable()) {
                byteBuf.resetReaderIndex();
                return 0;
            }
            by2 = byteBuf.readByte();
            if (by2 >= 0) {
                n4 |= by2 << 14;
            } else {
                n4 |= (by2 & 0x7F) << 14;
                if (!byteBuf.isReadable()) {
                    byteBuf.resetReaderIndex();
                    return 0;
                }
                by2 = byteBuf.readByte();
                if (by2 >= 0) {
                    n4 |= by2 << 21;
                } else {
                    n4 |= (by2 & 0x7F) << 21;
                    if (!byteBuf.isReadable()) {
                        byteBuf.resetReaderIndex();
                        return 0;
                    }
                    by2 = byteBuf.readByte();
                    n4 |= by2 << 28;
                    if (by2 < 0) {
                        throw new CorruptedFrameException("malformed varint.");
                    }
                }
            }
        }
        return n4;
    }
}

