/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.marshalling;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import io.grpc.netty.shaded.io.netty.handler.codec.marshalling.MarshallerProvider;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;

@ChannelHandler$Sharable
public class MarshallingEncoder
extends MessageToByteEncoder<Object> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;

    public MarshallingEncoder(MarshallerProvider marshallerProvider) {
        this.provider = marshallerProvider;
    }

    @Override
    public void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) {
        Marshaller marshaller = this.provider.getMarshaller(channelHandlerContext);
        int n4 = byteBuf.writerIndex();
        byteBuf.writeBytes(LENGTH_PLACEHOLDER);
        ChannelBufferByteOutput channelBufferByteOutput = new ChannelBufferByteOutput(byteBuf);
        marshaller.start((ByteOutput)channelBufferByteOutput);
        marshaller.writeObject(object);
        marshaller.finish();
        marshaller.close();
        byteBuf.setInt(n4, byteBuf.writerIndex() - n4 - 4);
    }
}

