/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.json;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.CorruptedFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class JsonObjectDecoder
extends ByteToMessageDecoder {
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private int openBraces;
    private int idx;
    private int lastReaderIndex;
    private int state;
    private boolean insideString;
    private final int maxObjectLength;
    private final boolean streamArrayElements;

    public JsonObjectDecoder() {
        this(0x100000);
    }

    public JsonObjectDecoder(int n4) {
        this(n4, false);
    }

    public JsonObjectDecoder(boolean bl3) {
        this(0x100000, bl3);
    }

    public JsonObjectDecoder(int n4, boolean bl3) {
        if (n4 < 1) {
            throw new IllegalArgumentException("maxObjectLength must be a positive int");
        }
        this.maxObjectLength = n4;
        this.streamArrayElements = bl3;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n4;
        int n7;
        if (this.state == -1) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        if (this.idx > byteBuf.readerIndex() && this.lastReaderIndex != byteBuf.readerIndex()) {
            this.idx = byteBuf.readerIndex() + (this.idx - this.lastReaderIndex);
        }
        if ((n7 = byteBuf.writerIndex()) > this.maxObjectLength) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            this.reset();
            throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + n7 + " bytes discarded");
        }
        for (n4 = this.idx; n4 < n7; ++n4) {
            byte by2 = byteBuf.getByte(n4);
            if (this.state == 1) {
                this.decodeByte(by2, byteBuf, n4);
                if (this.openBraces != 0) continue;
                ByteBuf byteBuf2 = this.extractObject(channelHandlerContext, byteBuf, byteBuf.readerIndex(), n4 + 1 - byteBuf.readerIndex());
                if (byteBuf2 != null) {
                    list.add(byteBuf2);
                }
                byteBuf.readerIndex(n4 + 1);
                this.reset();
                continue;
            }
            if (this.state == 2) {
                this.decodeByte(by2, byteBuf, n4);
                if (this.insideString || (this.openBraces != 1 || by2 != 44) && (this.openBraces != 0 || by2 != 93)) continue;
                int n8 = byteBuf.readerIndex();
                while (Character.isWhitespace(byteBuf.getByte(n8))) {
                    byteBuf.skipBytes(1);
                    ++n8;
                }
                for (n8 = n4 - 1; n8 >= byteBuf.readerIndex() && Character.isWhitespace(byteBuf.getByte(n8)); --n8) {
                }
                ByteBuf byteBuf3 = this.extractObject(channelHandlerContext, byteBuf, byteBuf.readerIndex(), n8 + 1 - byteBuf.readerIndex());
                if (byteBuf3 != null) {
                    list.add(byteBuf3);
                }
                byteBuf.readerIndex(n4 + 1);
                if (by2 != 93) continue;
                this.reset();
                continue;
            }
            if (by2 == 123 || by2 == 91) {
                this.initDecoding(by2);
                if (this.state != 2) continue;
                byteBuf.skipBytes(1);
                continue;
            }
            if (Character.isWhitespace(by2)) {
                byteBuf.skipBytes(1);
                continue;
            }
            this.state = -1;
            throw new CorruptedFrameException("invalid JSON received at byte position " + n4 + ": " + ByteBufUtil.hexDump(byteBuf));
        }
        this.idx = byteBuf.readableBytes() == 0 ? 0 : n4;
        this.lastReaderIndex = byteBuf.readerIndex();
    }

    protected ByteBuf extractObject(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.retainedSlice(n4, n7);
    }

    private void decodeByte(byte by2, ByteBuf byteBuf, int n4) {
        if (!(by2 != 123 && by2 != 91 || this.insideString)) {
            ++this.openBraces;
        } else if (!(by2 != 125 && by2 != 93 || this.insideString)) {
            --this.openBraces;
        } else if (by2 == 34) {
            if (!this.insideString) {
                this.insideString = true;
            } else {
                int n7 = 0;
                --n4;
                while (n4 >= 0 && byteBuf.getByte(n4) == 92) {
                    ++n7;
                    --n4;
                }
                if (n7 % 2 == 0) {
                    this.insideString = false;
                }
            }
        }
    }

    private void initDecoding(byte by2) {
        this.openBraces = 1;
        this.state = by2 == 91 && this.streamArrayElements ? 2 : 1;
    }

    private void reset() {
        this.insideString = false;
        this.state = 0;
        this.openBraces = 0;
    }
}

