/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamByteDistributor;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamByteDistributor$StreamState;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamByteDistributor$Writer;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$ParentChangedEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$State;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor$StateOnlyComparator;
import io.grpc.netty.shaded.io.netty.util.collection.IntCollections;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectMap;
import io.grpc.netty.shaded.io.netty.util.internal.DefaultPriorityQueue;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyPriorityQueue;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PriorityQueue;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;

public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    static final int INITIAL_CHILDREN_MAP_SIZE = Math.max(1, SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.http2.childrenMapSize", 2));
    private static final int DEFAULT_MAX_STATE_ONLY_SIZE = 5;
    private final Http2Connection$PropertyKey stateKey;
    private final IntObjectMap<WeightedFairQueueByteDistributor$State> stateOnlyMap;
    private final PriorityQueue<WeightedFairQueueByteDistributor$State> stateOnlyRemovalQueue;
    private final Http2Connection connection;
    private final WeightedFairQueueByteDistributor$State connectionState;
    private int allocationQuantum = 1024;
    private final int maxStateOnlySize;

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection) {
        this(http2Connection, 5);
    }

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection, int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "maxStateOnlySize");
        if (n4 == 0) {
            this.stateOnlyMap = IntCollections.emptyMap();
            this.stateOnlyRemovalQueue = EmptyPriorityQueue.instance();
        } else {
            this.stateOnlyMap = new IntObjectHashMap<WeightedFairQueueByteDistributor$State>(n4);
            this.stateOnlyRemovalQueue = new DefaultPriorityQueue<WeightedFairQueueByteDistributor$State>(WeightedFairQueueByteDistributor$StateOnlyComparator.INSTANCE, n4 + 2);
        }
        this.maxStateOnlySize = n4;
        this.connection = http2Connection;
        this.stateKey = http2Connection.newKey();
        Http2Stream http2Stream = http2Connection.connectionStream();
        this.connectionState = new WeightedFairQueueByteDistributor$State(this, http2Stream, 16);
        http2Stream.setProperty(this.stateKey, this.connectionState);
        http2Connection.addListener(new WeightedFairQueueByteDistributor$1(this));
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor$StreamState streamByteDistributor$StreamState) {
        this.state(streamByteDistributor$StreamState.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(streamByteDistributor$StreamState), streamByteDistributor$StreamState.hasFrame() && streamByteDistributor$StreamState.windowSize() >= 0);
    }

    @Override
    public void updateDependencyTree(int n4, int n7, short s11, boolean bl3) {
        ArrayList<WeightedFairQueueByteDistributor$ParentChangedEvent> arrayList;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = this.state(n4);
        if (weightedFairQueueByteDistributor$State2 == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            weightedFairQueueByteDistributor$State2 = new WeightedFairQueueByteDistributor$State(this, n4);
            this.stateOnlyRemovalQueue.add(weightedFairQueueByteDistributor$State2);
            this.stateOnlyMap.put(n4, weightedFairQueueByteDistributor$State2);
        }
        if ((weightedFairQueueByteDistributor$State = this.state(n7)) == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            weightedFairQueueByteDistributor$State = new WeightedFairQueueByteDistributor$State(this, n7);
            this.stateOnlyRemovalQueue.add(weightedFairQueueByteDistributor$State);
            this.stateOnlyMap.put(n7, weightedFairQueueByteDistributor$State);
            arrayList = new ArrayList(1);
            this.connectionState.takeChild(weightedFairQueueByteDistributor$State, false, arrayList);
            this.notifyParentChanged(arrayList);
        }
        if (weightedFairQueueByteDistributor$State2.activeCountForTree != 0 && weightedFairQueueByteDistributor$State2.parent != null) {
            weightedFairQueueByteDistributor$State2.parent.totalQueuedWeights += (long)(s11 - weightedFairQueueByteDistributor$State2.weight);
        }
        weightedFairQueueByteDistributor$State2.weight = s11;
        if (weightedFairQueueByteDistributor$State != weightedFairQueueByteDistributor$State2.parent || bl3 && weightedFairQueueByteDistributor$State.children.size() != 1) {
            if (weightedFairQueueByteDistributor$State.isDescendantOf(weightedFairQueueByteDistributor$State2)) {
                arrayList = new ArrayList(2 + (bl3 ? weightedFairQueueByteDistributor$State.children.size() : 0));
                weightedFairQueueByteDistributor$State2.parent.takeChild(weightedFairQueueByteDistributor$State, false, arrayList);
            } else {
                arrayList = new ArrayList<WeightedFairQueueByteDistributor$ParentChangedEvent>(1 + (bl3 ? weightedFairQueueByteDistributor$State.children.size() : 0));
            }
            weightedFairQueueByteDistributor$State.takeChild(weightedFairQueueByteDistributor$State2, bl3, arrayList);
            this.notifyParentChanged(arrayList);
        }
        while (this.stateOnlyRemovalQueue.size() > this.maxStateOnlySize) {
            arrayList = (WeightedFairQueueByteDistributor$State)this.stateOnlyRemovalQueue.poll();
            ((WeightedFairQueueByteDistributor$State)((Object)arrayList)).parent.removeChild((WeightedFairQueueByteDistributor$State)((Object)arrayList));
            this.stateOnlyMap.remove(((WeightedFairQueueByteDistributor$State)((Object)arrayList)).streamId);
        }
    }

    @Override
    public boolean distribute(int n4, StreamByteDistributor$Writer streamByteDistributor$Writer) {
        int n7;
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            n7 = this.connectionState.activeCountForTree;
            n4 -= this.distributeToChildren(n4, streamByteDistributor$Writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (n4 > 0 || n7 != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    public void allocationQuantum(int n4) {
        ObjectUtil.checkPositive(n4, "allocationQuantum");
        this.allocationQuantum = n4;
    }

    private int distribute(int n4, StreamByteDistributor$Writer streamByteDistributor$Writer, WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        if (weightedFairQueueByteDistributor$State.isActive()) {
            int n7 = Math.min(n4, weightedFairQueueByteDistributor$State.streamableBytes);
            weightedFairQueueByteDistributor$State.write(n7, streamByteDistributor$Writer);
            if (n7 == 0 && n4 != 0) {
                weightedFairQueueByteDistributor$State.updateStreamableBytes(weightedFairQueueByteDistributor$State.streamableBytes, false);
            }
            return n7;
        }
        return this.distributeToChildren(n4, streamByteDistributor$Writer, weightedFairQueueByteDistributor$State);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int distributeToChildren(int n4, StreamByteDistributor$Writer streamByteDistributor$Writer, WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State) {
        long l2 = weightedFairQueueByteDistributor$State.totalQueuedWeights;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = weightedFairQueueByteDistributor$State.pollPseudoTimeQueue();
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State3 = weightedFairQueueByteDistributor$State.peekPseudoTimeQueue();
        weightedFairQueueByteDistributor$State2.setDistributing();
        try {
            assert (weightedFairQueueByteDistributor$State3 == null || weightedFairQueueByteDistributor$State3.pseudoTimeToWrite >= weightedFairQueueByteDistributor$State2.pseudoTimeToWrite) : "nextChildState[" + weightedFairQueueByteDistributor$State3.streamId + "].pseudoTime(" + weightedFairQueueByteDistributor$State3.pseudoTimeToWrite + ") <  childState[" + weightedFairQueueByteDistributor$State2.streamId + "].pseudoTime(" + weightedFairQueueByteDistributor$State2.pseudoTimeToWrite + ")";
            int n7 = this.distribute(weightedFairQueueByteDistributor$State3 == null ? n4 : Math.min(n4, (int)Math.min((weightedFairQueueByteDistributor$State3.pseudoTimeToWrite - weightedFairQueueByteDistributor$State2.pseudoTimeToWrite) * (long)weightedFairQueueByteDistributor$State2.weight / l2 + (long)this.allocationQuantum, Integer.MAX_VALUE)), streamByteDistributor$Writer, weightedFairQueueByteDistributor$State2);
            weightedFairQueueByteDistributor$State.pseudoTime += (long)n7;
            weightedFairQueueByteDistributor$State2.updatePseudoTime(weightedFairQueueByteDistributor$State, n7, l2);
            int n8 = n7;
            return n8;
        }
        finally {
            weightedFairQueueByteDistributor$State2.unsetDistributing();
            if (weightedFairQueueByteDistributor$State2.activeCountForTree != 0) {
                weightedFairQueueByteDistributor$State.offerPseudoTimeQueue(weightedFairQueueByteDistributor$State2);
            }
        }
    }

    private WeightedFairQueueByteDistributor$State state(Http2Stream http2Stream) {
        return (WeightedFairQueueByteDistributor$State)http2Stream.getProperty(this.stateKey);
    }

    private WeightedFairQueueByteDistributor$State state(int n4) {
        Http2Stream http2Stream = this.connection.stream(n4);
        return http2Stream != null ? this.state(http2Stream) : this.stateOnlyMap.get(n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isChild(int n4, int n7, short s11) {
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State = this.state(n7);
        if (!weightedFairQueueByteDistributor$State.children.containsKey(n4)) return false;
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State2 = this.state(n4);
        if (weightedFairQueueByteDistributor$State2.parent != weightedFairQueueByteDistributor$State) return false;
        if (weightedFairQueueByteDistributor$State2.weight != s11) return false;
        return true;
    }

    int numChildren(int n4) {
        WeightedFairQueueByteDistributor$State weightedFairQueueByteDistributor$State = this.state(n4);
        return weightedFairQueueByteDistributor$State == null ? 0 : weightedFairQueueByteDistributor$State.children.size();
    }

    void notifyParentChanged(List<WeightedFairQueueByteDistributor$ParentChangedEvent> list) {
        for (int i3 = 0; i3 < list.size(); ++i3) {
            WeightedFairQueueByteDistributor$ParentChangedEvent weightedFairQueueByteDistributor$ParentChangedEvent = list.get(i3);
            this.stateOnlyRemovalQueue.priorityChanged(weightedFairQueueByteDistributor$ParentChangedEvent.state);
            if (weightedFairQueueByteDistributor$ParentChangedEvent.state.parent == null || weightedFairQueueByteDistributor$ParentChangedEvent.state.activeCountForTree == 0) continue;
            weightedFairQueueByteDistributor$ParentChangedEvent.state.parent.offerAndInitializePseudoTime(weightedFairQueueByteDistributor$ParentChangedEvent.state);
            weightedFairQueueByteDistributor$ParentChangedEvent.state.parent.activeCountChangeForTree(weightedFairQueueByteDistributor$ParentChangedEvent.state.activeCountForTree);
        }
    }

    static /* synthetic */ IntObjectMap access$000(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.stateOnlyMap;
    }

    static /* synthetic */ WeightedFairQueueByteDistributor$State access$100(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.connectionState;
    }

    static /* synthetic */ PriorityQueue access$200(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.stateOnlyRemovalQueue;
    }

    static /* synthetic */ Http2Connection$PropertyKey access$300(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.stateKey;
    }

    static /* synthetic */ WeightedFairQueueByteDistributor$State access$400(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor, Http2Stream http2Stream) {
        return weightedFairQueueByteDistributor.state(http2Stream);
    }

    static /* synthetic */ int access$500(WeightedFairQueueByteDistributor weightedFairQueueByteDistributor) {
        return weightedFairQueueByteDistributor.maxStateOnlySize;
    }
}

