/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder$DataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder$HeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder$Http2ChannelClosedException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder$Http2GoAwayException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder$PendingStream;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class StreamBufferingEncoder
extends DecoratingHttp2ConnectionEncoder {
    private final TreeMap<Integer, StreamBufferingEncoder$PendingStream> pendingStreams = new TreeMap();
    private int maxConcurrentStreams;
    private boolean closed;

    public StreamBufferingEncoder(Http2ConnectionEncoder http2ConnectionEncoder) {
        this(http2ConnectionEncoder, 100);
    }

    public StreamBufferingEncoder(Http2ConnectionEncoder http2ConnectionEncoder, int n4) {
        super(http2ConnectionEncoder);
        this.maxConcurrentStreams = n4;
        this.connection().addListener(new StreamBufferingEncoder$1(this));
    }

    public int numBufferedStreams() {
        return this.pendingStreams.size();
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3, ChannelPromise channelPromise) {
        return this.writeHeaders(channelHandlerContext, n4, http2Headers, 0, (short)16, false, n7, bl3, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4, ChannelPromise channelPromise) {
        if (this.closed) {
            return channelPromise.setFailure(new StreamBufferingEncoder$Http2ChannelClosedException());
        }
        if (this.isExistingStream(n4) || this.connection().goAwayReceived()) {
            return super.writeHeaders(channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4, channelPromise);
        }
        if (this.canCreateStream()) {
            return super.writeHeaders(channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4, channelPromise);
        }
        StreamBufferingEncoder$PendingStream streamBufferingEncoder$PendingStream = this.pendingStreams.get(n4);
        if (streamBufferingEncoder$PendingStream == null) {
            streamBufferingEncoder$PendingStream = new StreamBufferingEncoder$PendingStream(channelHandlerContext, n4);
            this.pendingStreams.put(n4, streamBufferingEncoder$PendingStream);
        }
        streamBufferingEncoder$PendingStream.frames.add(new StreamBufferingEncoder$HeadersFrame(this, http2Headers, n7, s11, bl3, n8, bl4, channelPromise));
        return channelPromise;
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n4, long l2, ChannelPromise channelPromise) {
        if (this.isExistingStream(n4)) {
            return super.writeRstStream(channelHandlerContext, n4, l2, channelPromise);
        }
        StreamBufferingEncoder$PendingStream streamBufferingEncoder$PendingStream = this.pendingStreams.remove(n4);
        if (streamBufferingEncoder$PendingStream != null) {
            streamBufferingEncoder$PendingStream.close(null);
            channelPromise.setSuccess();
        } else {
            channelPromise.setFailure(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", n4));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3, ChannelPromise channelPromise) {
        if (this.isExistingStream(n4)) {
            return super.writeData(channelHandlerContext, n4, byteBuf, n7, bl3, channelPromise);
        }
        StreamBufferingEncoder$PendingStream streamBufferingEncoder$PendingStream = this.pendingStreams.get(n4);
        if (streamBufferingEncoder$PendingStream != null) {
            streamBufferingEncoder$PendingStream.frames.add(new StreamBufferingEncoder$DataFrame(this, byteBuf, n7, bl3, channelPromise));
        } else {
            ReferenceCountUtil.safeRelease(byteBuf);
            channelPromise.setFailure(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", n4));
        }
        return channelPromise;
    }

    @Override
    public void remoteSettings(Http2Settings http2Settings) {
        super.remoteSettings(http2Settings);
        this.maxConcurrentStreams = this.connection().local().maxActiveStreams();
        this.tryCreatePendingStreams();
    }

    @Override
    public void close() {
        try {
            if (!this.closed) {
                this.closed = true;
                StreamBufferingEncoder$Http2ChannelClosedException streamBufferingEncoder$Http2ChannelClosedException = new StreamBufferingEncoder$Http2ChannelClosedException();
                while (!this.pendingStreams.isEmpty()) {
                    StreamBufferingEncoder$PendingStream streamBufferingEncoder$PendingStream = this.pendingStreams.pollFirstEntry().getValue();
                    streamBufferingEncoder$PendingStream.close(streamBufferingEncoder$Http2ChannelClosedException);
                }
            }
        }
        finally {
            super.close();
        }
    }

    private void tryCreatePendingStreams() {
        while (!this.pendingStreams.isEmpty() && this.canCreateStream()) {
            Map.Entry<Integer, StreamBufferingEncoder$PendingStream> entry = this.pendingStreams.pollFirstEntry();
            StreamBufferingEncoder$PendingStream streamBufferingEncoder$PendingStream = entry.getValue();
            try {
                streamBufferingEncoder$PendingStream.sendFrames();
            }
            catch (Throwable throwable) {
                streamBufferingEncoder$PendingStream.close(throwable);
            }
        }
    }

    private void cancelGoAwayStreams(int n4, long l2, ByteBuf byteBuf) {
        Iterator<StreamBufferingEncoder$PendingStream> iterator = this.pendingStreams.values().iterator();
        StreamBufferingEncoder$Http2GoAwayException streamBufferingEncoder$Http2GoAwayException = new StreamBufferingEncoder$Http2GoAwayException(n4, l2, ByteBufUtil.getBytes(byteBuf));
        while (iterator.hasNext()) {
            StreamBufferingEncoder$PendingStream streamBufferingEncoder$PendingStream = iterator.next();
            if (streamBufferingEncoder$PendingStream.streamId <= n4) continue;
            iterator.remove();
            streamBufferingEncoder$PendingStream.close(streamBufferingEncoder$Http2GoAwayException);
        }
    }

    private boolean canCreateStream() {
        return this.connection().local().numActiveStreams() < this.maxConcurrentStreams;
    }

    private boolean isExistingStream(int n4) {
        return n4 <= this.connection().local().lastStreamCreated();
    }

    static /* synthetic */ void access$000(StreamBufferingEncoder streamBufferingEncoder, int n4, long l2, ByteBuf byteBuf) {
        streamBufferingEncoder.cancelGoAwayStreams(n4, l2, byteBuf);
    }

    static /* synthetic */ void access$100(StreamBufferingEncoder streamBufferingEncoder) {
        streamBufferingEncoder.tryCreatePendingStreams();
    }
}

