/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.CharSequenceValueConverter;
import io.grpc.netty.shaded.io.netty.handler.codec.Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers$PseudoHeaderName;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.ReadOnlyHttp2Headers$ReadOnlyIterator;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.ReadOnlyHttp2Headers$ReadOnlyValueIterator;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.HashingStrategy;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private static final byte PSEUDO_HEADER_TOKEN = 58;
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    public static ReadOnlyHttp2Headers trailers(boolean bl3, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl3, EmptyArrays.EMPTY_ASCII_STRINGS, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers clientHeaders(boolean bl3, AsciiString asciiString, AsciiString asciiString2, AsciiString asciiString3, AsciiString asciiString4, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl3, new AsciiString[]{Http2Headers$PseudoHeaderName.METHOD.value(), asciiString, Http2Headers$PseudoHeaderName.PATH.value(), asciiString2, Http2Headers$PseudoHeaderName.SCHEME.value(), asciiString3, Http2Headers$PseudoHeaderName.AUTHORITY.value(), asciiString4}, asciiStringArray);
    }

    public static ReadOnlyHttp2Headers serverHeaders(boolean bl3, AsciiString asciiString, AsciiString ... asciiStringArray) {
        return new ReadOnlyHttp2Headers(bl3, new AsciiString[]{Http2Headers$PseudoHeaderName.STATUS.value(), asciiString}, asciiStringArray);
    }

    private ReadOnlyHttp2Headers(boolean bl3, AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        assert ((asciiStringArray.length & 1) == 0);
        if ((asciiStringArray2.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (bl3) {
            ReadOnlyHttp2Headers.validateHeaders(asciiStringArray, asciiStringArray2);
        }
        this.pseudoHeaders = asciiStringArray;
        this.otherHeaders = asciiStringArray2;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] asciiStringArray, AsciiString ... asciiStringArray2) {
        int n4;
        for (n4 = 1; n4 < asciiStringArray.length; n4 += 2) {
            if (asciiStringArray[n4] != null) continue;
            throw new IllegalArgumentException("pseudoHeaders value at index " + n4 + " is null");
        }
        n4 = 0;
        int n7 = asciiStringArray2.length - 1;
        for (int i3 = 0; i3 < n7; i3 += 2) {
            AsciiString asciiString = asciiStringArray2[i3];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName(asciiString);
            if (n4 == 0 && !asciiString.isEmpty() && asciiString.byteAt(0) != 58) {
                n4 = 1;
            } else if (n4 != 0 && !asciiString.isEmpty() && asciiString.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i3 + " is a pseudo header that appears after non-pseudo headers.");
            }
            if (asciiStringArray2[i3 + 1] != null) continue;
            throw new IllegalArgumentException("otherHeaders value at index " + (i3 + 1) + " is null");
        }
    }

    private AsciiString get0(CharSequence charSequence) {
        int n4;
        int n7 = AsciiString.hashCode(charSequence);
        int n8 = this.pseudoHeaders.length - 1;
        for (n4 = 0; n4 < n8; n4 += 2) {
            AsciiString asciiString = this.pseudoHeaders[n4];
            if (asciiString.hashCode() != n7 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.pseudoHeaders[n4 + 1];
        }
        n4 = this.otherHeaders.length - 1;
        for (int i3 = 0; i3 < n4; i3 += 2) {
            AsciiString asciiString = this.otherHeaders[i3];
            if (asciiString.hashCode() != n7 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            return this.otherHeaders[i3 + 1];
        }
        return null;
    }

    @Override
    public CharSequence get(CharSequence charSequence) {
        return this.get0(charSequence);
    }

    @Override
    public CharSequence get(CharSequence charSequence, CharSequence charSequence2) {
        CharSequence charSequence3 = this.get(charSequence);
        return charSequence3 != null ? charSequence3 : charSequence2;
    }

    @Override
    public CharSequence getAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public CharSequence getAndRemove(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public List<CharSequence> getAll(CharSequence charSequence) {
        int n4;
        int n7 = AsciiString.hashCode(charSequence);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n8 = this.pseudoHeaders.length - 1;
        for (n4 = 0; n4 < n8; n4 += 2) {
            AsciiString asciiString = this.pseudoHeaders[n4];
            if (asciiString.hashCode() != n7 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add(this.pseudoHeaders[n4 + 1]);
        }
        n4 = this.otherHeaders.length - 1;
        for (int i3 = 0; i3 < n4; i3 += 2) {
            AsciiString asciiString = this.otherHeaders[i3];
            if (asciiString.hashCode() != n7 || !asciiString.contentEqualsIgnoreCase(charSequence)) continue;
            arrayList.add(this.otherHeaders[i3 + 1]);
        }
        return arrayList;
    }

    @Override
    public List<CharSequence> getAllAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Boolean getBoolean(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Boolean.valueOf(CharSequenceValueConverter.INSTANCE.convertToBoolean(asciiString)) : null;
    }

    @Override
    public boolean getBoolean(CharSequence charSequence, boolean bl3) {
        Boolean bl4 = this.getBoolean(charSequence);
        return bl4 != null ? bl4 : bl3;
    }

    @Override
    public Byte getByte(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Byte.valueOf(CharSequenceValueConverter.INSTANCE.convertToByte(asciiString)) : null;
    }

    @Override
    public byte getByte(CharSequence charSequence, byte by2) {
        Byte by3 = this.getByte(charSequence);
        return by3 != null ? by3 : by2;
    }

    @Override
    public Character getChar(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Character.valueOf(CharSequenceValueConverter.INSTANCE.convertToChar(asciiString)) : null;
    }

    @Override
    public char getChar(CharSequence charSequence, char c10) {
        Character c11 = this.getChar(charSequence);
        return c11 != null ? c11.charValue() : c10;
    }

    @Override
    public Short getShort(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Short.valueOf(CharSequenceValueConverter.INSTANCE.convertToShort(asciiString)) : null;
    }

    @Override
    public short getShort(CharSequence charSequence, short s11) {
        Short s12 = this.getShort(charSequence);
        return s12 != null ? s12 : s11;
    }

    @Override
    public Integer getInt(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Integer.valueOf(CharSequenceValueConverter.INSTANCE.convertToInt(asciiString)) : null;
    }

    @Override
    public int getInt(CharSequence charSequence, int n4) {
        Integer n7 = this.getInt(charSequence);
        return n7 != null ? n7 : n4;
    }

    @Override
    public Long getLong(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToLong(asciiString)) : null;
    }

    @Override
    public long getLong(CharSequence charSequence, long l2) {
        Long l10 = this.getLong(charSequence);
        return l10 != null ? l10 : l2;
    }

    @Override
    public Float getFloat(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Float.valueOf(CharSequenceValueConverter.INSTANCE.convertToFloat(asciiString)) : null;
    }

    @Override
    public float getFloat(CharSequence charSequence, float f8) {
        Float f9 = this.getFloat(charSequence);
        return f9 != null ? f9.floatValue() : f8;
    }

    @Override
    public Double getDouble(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Double.valueOf(CharSequenceValueConverter.INSTANCE.convertToDouble(asciiString)) : null;
    }

    @Override
    public double getDouble(CharSequence charSequence, double d8) {
        Double d10 = this.getDouble(charSequence);
        return d10 != null ? d10 : d8;
    }

    @Override
    public Long getTimeMillis(CharSequence charSequence) {
        AsciiString asciiString = this.get0(charSequence);
        return asciiString != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToTimeMillis(asciiString)) : null;
    }

    @Override
    public long getTimeMillis(CharSequence charSequence, long l2) {
        Long l10 = this.getTimeMillis(charSequence);
        return l10 != null ? l10 : l2;
    }

    @Override
    public Boolean getBooleanAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean getBooleanAndRemove(CharSequence charSequence, boolean bl3) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Byte getByteAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public byte getByteAndRemove(CharSequence charSequence, byte by2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Character getCharAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public char getCharAndRemove(CharSequence charSequence, char c10) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Short getShortAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public short getShortAndRemove(CharSequence charSequence, short s11) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Integer getIntAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public int getIntAndRemove(CharSequence charSequence, int n4) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Long getLongAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public long getLongAndRemove(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Float getFloatAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public float getFloatAndRemove(CharSequence charSequence, float f8) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Double getDoubleAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public double getDoubleAndRemove(CharSequence charSequence, double d8) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Long getTimeMillisAndRemove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public long getTimeMillisAndRemove(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return this.get(charSequence) != null;
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return this.contains(charSequence, charSequence2, false);
    }

    @Override
    public boolean containsObject(CharSequence charSequence, Object object) {
        if (object instanceof CharSequence) {
            return this.contains(charSequence, (CharSequence)object);
        }
        return this.contains(charSequence, object.toString());
    }

    @Override
    public boolean containsBoolean(CharSequence charSequence, boolean bl3) {
        return this.contains(charSequence, String.valueOf(bl3));
    }

    @Override
    public boolean containsByte(CharSequence charSequence, byte by2) {
        return this.contains(charSequence, String.valueOf(by2));
    }

    @Override
    public boolean containsChar(CharSequence charSequence, char c10) {
        return this.contains(charSequence, String.valueOf(c10));
    }

    @Override
    public boolean containsShort(CharSequence charSequence, short s11) {
        return this.contains(charSequence, String.valueOf(s11));
    }

    @Override
    public boolean containsInt(CharSequence charSequence, int n4) {
        return this.contains(charSequence, String.valueOf(n4));
    }

    @Override
    public boolean containsLong(CharSequence charSequence, long l2) {
        return this.contains(charSequence, String.valueOf(l2));
    }

    @Override
    public boolean containsFloat(CharSequence charSequence, float f8) {
        return false;
    }

    @Override
    public boolean containsDouble(CharSequence charSequence, double d8) {
        return this.contains(charSequence, String.valueOf(d8));
    }

    @Override
    public boolean containsTimeMillis(CharSequence charSequence, long l2) {
        return this.contains(charSequence, String.valueOf(l2));
    }

    @Override
    public int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.pseudoHeaders.length == 0 && this.otherHeaders.length == 0;
    }

    @Override
    public Set<CharSequence> names() {
        int n4;
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<CharSequence> linkedHashSet = new LinkedHashSet<CharSequence>(this.size());
        int n7 = this.pseudoHeaders.length - 1;
        for (n4 = 0; n4 < n7; n4 += 2) {
            linkedHashSet.add(this.pseudoHeaders[n4]);
        }
        n4 = this.otherHeaders.length - 1;
        for (int i3 = 0; i3 < n4; i3 += 2) {
            linkedHashSet.add(this.otherHeaders[i3]);
        }
        return linkedHashSet;
    }

    @Override
    public Http2Headers add(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addBoolean(CharSequence charSequence, boolean bl3) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addByte(CharSequence charSequence, byte by2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addChar(CharSequence charSequence, char c10) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addShort(CharSequence charSequence, short s11) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addInt(CharSequence charSequence, int n4) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addLong(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addFloat(CharSequence charSequence, float f8) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addDouble(CharSequence charSequence, double d8) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addTimeMillis(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence charSequence, CharSequence charSequence2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence charSequence, CharSequence ... charSequenceArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence charSequence, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence charSequence, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence charSequence, Object ... objectArray) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setBoolean(CharSequence charSequence, boolean bl3) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setByte(CharSequence charSequence, byte by2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setChar(CharSequence charSequence, char c10) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setShort(CharSequence charSequence, short s11) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setInt(CharSequence charSequence, int n4) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setLong(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setFloat(CharSequence charSequence, float f8) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setDouble(CharSequence charSequence, double d8) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setTimeMillis(CharSequence charSequence, long l2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean remove(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers clear() {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyHttp2Headers$ReadOnlyIterator(this, null);
    }

    @Override
    public Iterator<CharSequence> valueIterator(CharSequence charSequence) {
        return new ReadOnlyHttp2Headers$ReadOnlyValueIterator(this, charSequence);
    }

    @Override
    public Http2Headers method(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers scheme(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers authority(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers path(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers status(CharSequence charSequence) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public CharSequence method() {
        return this.get(Http2Headers$PseudoHeaderName.METHOD.value());
    }

    @Override
    public CharSequence scheme() {
        return this.get(Http2Headers$PseudoHeaderName.SCHEME.value());
    }

    @Override
    public CharSequence authority() {
        return this.get(Http2Headers$PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public CharSequence path() {
        return this.get(Http2Headers$PseudoHeaderName.PATH.value());
    }

    @Override
    public CharSequence status() {
        return this.get(Http2Headers$PseudoHeaderName.STATUS.value());
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl3) {
        int n4 = AsciiString.hashCode(charSequence);
        HashingStrategy<CharSequence> hashingStrategy = bl3 ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        int n7 = hashingStrategy.hashCode(charSequence2);
        return ReadOnlyHttp2Headers.contains(charSequence, n4, charSequence2, n7, hashingStrategy, this.otherHeaders) || ReadOnlyHttp2Headers.contains(charSequence, n4, charSequence2, n7, hashingStrategy, this.pseudoHeaders);
    }

    private static boolean contains(CharSequence charSequence, int n4, CharSequence charSequence2, int n7, HashingStrategy<CharSequence> hashingStrategy, AsciiString[] asciiStringArray) {
        int n8 = asciiStringArray.length - 1;
        for (int i3 = 0; i3 < n8; i3 += 2) {
            AsciiString asciiString = asciiStringArray[i3];
            AsciiString asciiString2 = asciiStringArray[i3 + 1];
            if (asciiString.hashCode() != n4 || asciiString2.hashCode() != n7 || !asciiString.contentEqualsIgnoreCase(charSequence) || !hashingStrategy.equals(asciiString2, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String string = "";
        for (Map.Entry<CharSequence, CharSequence> entry : this) {
            stringBuilder.append(string);
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
            string = ", ";
        }
        return stringBuilder.append(']').toString();
    }

    static /* synthetic */ AsciiString[] access$100(ReadOnlyHttp2Headers readOnlyHttp2Headers) {
        return readOnlyHttp2Headers.pseudoHeaders;
    }

    static /* synthetic */ AsciiString[] access$200(ReadOnlyHttp2Headers readOnlyHttp2Headers) {
        return readOnlyHttp2Headers.otherHeaders;
    }
}

