/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2EventAdapter;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HttpConversionUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter$ImmediateSendDetector;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class InboundHttp2ToHttpAdapter
extends Http2EventAdapter {
    private static final InboundHttp2ToHttpAdapter$ImmediateSendDetector DEFAULT_SEND_DETECTOR = new InboundHttp2ToHttpAdapter$1();
    private final int maxContentLength;
    private final InboundHttp2ToHttpAdapter$ImmediateSendDetector sendDetector;
    private final Http2Connection$PropertyKey messageKey;
    private final boolean propagateSettings;
    protected final Http2Connection connection;
    protected final boolean validateHttpHeaders;

    protected InboundHttp2ToHttpAdapter(Http2Connection http2Connection, int n4, boolean bl3, boolean bl4) {
        ObjectUtil.checkNotNull(http2Connection, "connection");
        if (n4 <= 0) {
            throw new IllegalArgumentException("maxContentLength: " + n4 + " (expected: > 0)");
        }
        this.connection = http2Connection;
        this.maxContentLength = n4;
        this.validateHttpHeaders = bl3;
        this.propagateSettings = bl4;
        this.sendDetector = DEFAULT_SEND_DETECTOR;
        this.messageKey = http2Connection.newKey();
    }

    protected final void removeMessage(Http2Stream http2Stream, boolean bl3) {
        FullHttpMessage fullHttpMessage = (FullHttpMessage)http2Stream.removeProperty(this.messageKey);
        if (bl3 && fullHttpMessage != null) {
            fullHttpMessage.release();
        }
    }

    protected final FullHttpMessage getMessage(Http2Stream http2Stream) {
        return (FullHttpMessage)http2Stream.getProperty(this.messageKey);
    }

    protected final void putMessage(Http2Stream http2Stream, FullHttpMessage fullHttpMessage) {
        FullHttpMessage fullHttpMessage2 = http2Stream.setProperty(this.messageKey, fullHttpMessage);
        if (fullHttpMessage2 != fullHttpMessage && fullHttpMessage2 != null) {
            fullHttpMessage2.release();
        }
    }

    @Override
    public void onStreamRemoved(Http2Stream http2Stream) {
        this.removeMessage(http2Stream, true);
    }

    protected void fireChannelRead(ChannelHandlerContext channelHandlerContext, FullHttpMessage fullHttpMessage, boolean bl3, Http2Stream http2Stream) {
        this.removeMessage(http2Stream, bl3);
        HttpUtil.setContentLength(fullHttpMessage, fullHttpMessage.content().readableBytes());
        channelHandlerContext.fireChannelRead(fullHttpMessage);
    }

    protected FullHttpMessage newMessage(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl3, ByteBufAllocator byteBufAllocator) {
        return this.connection.isServer() ? HttpConversionUtil.toFullHttpRequest(http2Stream.id(), http2Headers, byteBufAllocator, bl3) : HttpConversionUtil.toFullHttpResponse(http2Stream.id(), http2Headers, byteBufAllocator, bl3);
    }

    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, Http2Headers http2Headers, boolean bl3, boolean bl4, boolean bl5) {
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        boolean bl6 = true;
        if (fullHttpMessage == null) {
            fullHttpMessage = this.newMessage(http2Stream, http2Headers, this.validateHttpHeaders, channelHandlerContext.alloc());
        } else if (bl4) {
            bl6 = false;
            HttpConversionUtil.addHttp2ToHttpHeaders(http2Stream.id(), http2Headers, fullHttpMessage, bl5);
        } else {
            bl6 = false;
            fullHttpMessage = null;
        }
        if (this.sendDetector.mustSendImmediately(fullHttpMessage)) {
            FullHttpMessage fullHttpMessage2 = bl3 ? null : this.sendDetector.copyIfNeeded(fullHttpMessage);
            this.fireChannelRead(channelHandlerContext, fullHttpMessage, bl6, http2Stream);
            return fullHttpMessage2;
        }
        return fullHttpMessage;
    }

    private void processHeadersEnd(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, FullHttpMessage fullHttpMessage, boolean bl3) {
        if (bl3) {
            this.fireChannelRead(channelHandlerContext, fullHttpMessage, this.getMessage(http2Stream) != fullHttpMessage, http2Stream);
        } else {
            this.putMessage(http2Stream, fullHttpMessage);
        }
    }

    @Override
    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3) {
        Http2Stream http2Stream = this.connection.stream(n4);
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        if (fullHttpMessage == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Data Frame received for unknown stream id %d", n4);
        }
        ByteBuf byteBuf2 = fullHttpMessage.content();
        int n8 = byteBuf.readableBytes();
        if (byteBuf2.readableBytes() > this.maxContentLength - n8) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Content length exceeded max of %d for stream id %d", this.maxContentLength, n4);
        }
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n8);
        if (bl3) {
            this.fireChannelRead(channelHandlerContext, fullHttpMessage, false, http2Stream);
        }
        return n8 + n7;
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3) {
        Http2Stream http2Stream = this.connection.stream(n4);
        FullHttpMessage fullHttpMessage = this.processHeadersBegin(channelHandlerContext, http2Stream, http2Headers, bl3, true, true);
        if (fullHttpMessage != null) {
            this.processHeadersEnd(channelHandlerContext, http2Stream, fullHttpMessage, bl3);
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4) {
        Http2Stream http2Stream = this.connection.stream(n4);
        FullHttpMessage fullHttpMessage = this.processHeadersBegin(channelHandlerContext, http2Stream, http2Headers, bl4, true, true);
        if (fullHttpMessage != null) {
            if (n7 != 0) {
                fullHttpMessage.headers().setInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), n7);
            }
            fullHttpMessage.headers().setShort(HttpConversionUtil$ExtensionHeaderNames.STREAM_WEIGHT.text(), s11);
            this.processHeadersEnd(channelHandlerContext, http2Stream, fullHttpMessage, bl4);
        }
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n4, long l2) {
        Http2Stream http2Stream = this.connection.stream(n4);
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        if (fullHttpMessage != null) {
            this.onRstStreamRead(http2Stream, fullHttpMessage);
        }
        channelHandlerContext.fireExceptionCaught(Http2Exception.streamError(n4, Http2Error.valueOf(l2), "HTTP/2 to HTTP layer caught stream reset", new Object[0]));
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n4, int n7, Http2Headers http2Headers, int n8) {
        FullHttpMessage fullHttpMessage;
        Http2Stream http2Stream = this.connection.stream(n7);
        if (http2Headers.status() == null) {
            http2Headers.status(HttpResponseStatus.OK.codeAsText());
        }
        if ((fullHttpMessage = this.processHeadersBegin(channelHandlerContext, http2Stream, http2Headers, false, false, false)) == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Push Promise Frame received for pre-existing stream id %d", n7);
        }
        fullHttpMessage.headers().setInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_PROMISE_ID.text(), n4);
        fullHttpMessage.headers().setShort(HttpConversionUtil$ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        this.processHeadersEnd(channelHandlerContext, http2Stream, fullHttpMessage, false);
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        if (this.propagateSettings) {
            channelHandlerContext.fireChannelRead(http2Settings);
        }
    }

    protected void onRstStreamRead(Http2Stream http2Stream, FullHttpMessage fullHttpMessage) {
        this.removeMessage(http2Stream, true);
    }
}

