/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.CharSequenceMap;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers$PseudoHeaderName;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import java.util.Map;

final class HttpConversionUtil$Http2ToHttpHeaderTranslator {
    private static final CharSequenceMap<AsciiString> REQUEST_HEADER_TRANSLATIONS = new CharSequenceMap();
    private static final CharSequenceMap<AsciiString> RESPONSE_HEADER_TRANSLATIONS = new CharSequenceMap();
    private final int streamId;
    private final HttpHeaders output;
    private final CharSequenceMap<AsciiString> translations;

    HttpConversionUtil$Http2ToHttpHeaderTranslator(int n4, HttpHeaders httpHeaders, boolean bl3) {
        this.streamId = n4;
        this.output = httpHeaders;
        this.translations = bl3 ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
    }

    public void translateHeaders(Iterable<Map.Entry<CharSequence, CharSequence>> iterable) {
        StringBuilder stringBuilder = null;
        for (Map.Entry<CharSequence, CharSequence> entry : iterable) {
            CharSequence charSequence = entry.getKey();
            CharSequence charSequence2 = entry.getValue();
            AsciiString asciiString = (AsciiString)this.translations.get(charSequence);
            if (asciiString != null) {
                this.output.add((CharSequence)asciiString, (Object)AsciiString.of(charSequence2));
                continue;
            }
            if (Http2Headers$PseudoHeaderName.isPseudoHeader(charSequence)) continue;
            if (charSequence.length() == 0 || charSequence.charAt(0) == ':') {
                throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 header '%s' encountered in translation to HTTP/1.x", charSequence);
            }
            if (HttpHeaderNames.COOKIE.equals(charSequence)) {
                if (stringBuilder == null) {
                    stringBuilder = InternalThreadLocalMap.get().stringBuilder();
                } else if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(charSequence2);
                continue;
            }
            this.output.add(charSequence, (Object)charSequence2);
        }
        if (stringBuilder != null) {
            this.output.add((CharSequence)HttpHeaderNames.COOKIE, (Object)stringBuilder.toString());
        }
    }

    private void translateHeader(Map.Entry<CharSequence, CharSequence> entry) {
    }

    static {
        RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers$PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
        RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers$PseudoHeaderName.SCHEME.value(), HttpConversionUtil$ExtensionHeaderNames.SCHEME.text());
        REQUEST_HEADER_TRANSLATIONS.add(RESPONSE_HEADER_TRANSLATIONS);
        RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers$PseudoHeaderName.PATH.value(), HttpConversionUtil$ExtensionHeaderNames.PATH.text());
    }
}

