/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler$Sharable;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.EncoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToMessageCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultLastHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpScheme;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2DataFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HttpConversionUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.Attribute;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import java.util.List;

@ChannelHandler$Sharable
public class Http2StreamFrameToHttpObjectCodec
extends MessageToMessageCodec<Http2StreamFrame, HttpObject> {
    private static final AttributeKey<HttpScheme> SCHEME_ATTR_KEY = AttributeKey.valueOf(HttpScheme.class, "STREAMFRAMECODEC_SCHEME");
    private final boolean isServer;
    private final boolean validateHeaders;

    public Http2StreamFrameToHttpObjectCodec(boolean bl3, boolean bl4) {
        this.isServer = bl3;
        this.validateHeaders = bl4;
    }

    public Http2StreamFrameToHttpObjectCodec(boolean bl3) {
        this(bl3, true);
    }

    @Override
    public boolean acceptInboundMessage(Object object) {
        return object instanceof Http2HeadersFrame || object instanceof Http2DataFrame;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, Http2StreamFrame http2StreamFrame, List<Object> list) {
        if (http2StreamFrame instanceof Http2HeadersFrame) {
            Http2HeadersFrame http2HeadersFrame = (Http2HeadersFrame)http2StreamFrame;
            Http2Headers http2Headers = http2HeadersFrame.headers();
            Http2FrameStream http2FrameStream = http2HeadersFrame.stream();
            int n4 = http2FrameStream == null ? 0 : http2FrameStream.id();
            CharSequence charSequence = http2Headers.status();
            if (null != charSequence && HttpResponseStatus.CONTINUE.codeAsText().contentEquals(charSequence)) {
                FullHttpMessage fullHttpMessage = this.newFullMessage(n4, http2Headers, channelHandlerContext.alloc());
                list.add(fullHttpMessage);
                return;
            }
            if (http2HeadersFrame.isEndStream()) {
                if (http2Headers.method() == null && charSequence == null) {
                    DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
                    HttpConversionUtil.addHttp2ToHttpHeaders(n4, http2Headers, defaultLastHttpContent.trailingHeaders(), HttpVersion.HTTP_1_1, true, true);
                    list.add(defaultLastHttpContent);
                } else {
                    FullHttpMessage fullHttpMessage = this.newFullMessage(n4, http2Headers, channelHandlerContext.alloc());
                    list.add(fullHttpMessage);
                }
            } else {
                HttpMessage httpMessage = this.newMessage(n4, http2Headers);
                if (!HttpUtil.isContentLengthSet(httpMessage)) {
                    httpMessage.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                list.add(httpMessage);
            }
        } else if (http2StreamFrame instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)http2StreamFrame;
            if (http2DataFrame.isEndStream()) {
                list.add(new DefaultLastHttpContent(http2DataFrame.content().retain(), this.validateHeaders));
            } else {
                list.add(new DefaultHttpContent(http2DataFrame.content().retain()));
            }
        }
    }

    private void encodeLastContent(LastHttpContent lastHttpContent, List<Object> list) {
        boolean bl3;
        boolean bl4 = bl3 = !(lastHttpContent instanceof FullHttpMessage) && lastHttpContent.trailingHeaders().isEmpty();
        if (lastHttpContent.content().isReadable() || bl3) {
            list.add(new DefaultHttp2DataFrame(lastHttpContent.content().retain(), lastHttpContent.trailingHeaders().isEmpty()));
        }
        if (!lastHttpContent.trailingHeaders().isEmpty()) {
            Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(lastHttpContent.trailingHeaders(), this.validateHeaders);
            list.add(new DefaultHttp2HeadersFrame(http2Headers, true));
        }
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        Object object;
        if (httpObject instanceof HttpResponse && (object = (HttpResponse)httpObject).status().equals(HttpResponseStatus.CONTINUE)) {
            if (object instanceof FullHttpResponse) {
                Http2Headers http2Headers = this.toHttp2Headers(channelHandlerContext, (HttpMessage)object);
                list.add(new DefaultHttp2HeadersFrame(http2Headers, false));
                return;
            }
            throw new EncoderException(HttpResponseStatus.CONTINUE.toString() + " must be a FullHttpResponse");
        }
        if (httpObject instanceof HttpMessage) {
            object = this.toHttp2Headers(channelHandlerContext, (HttpMessage)httpObject);
            boolean bl3 = false;
            if (httpObject instanceof FullHttpMessage) {
                FullHttpMessage fullHttpMessage = (FullHttpMessage)httpObject;
                bl3 = !fullHttpMessage.content().isReadable() && fullHttpMessage.trailingHeaders().isEmpty();
            }
            list.add(new DefaultHttp2HeadersFrame((Http2Headers)object, bl3));
        }
        if (httpObject instanceof LastHttpContent) {
            object = (LastHttpContent)httpObject;
            this.encodeLastContent((LastHttpContent)object, list);
        } else if (httpObject instanceof HttpContent) {
            object = (HttpContent)httpObject;
            list.add(new DefaultHttp2DataFrame(object.content().retain(), false));
        }
    }

    private Http2Headers toHttp2Headers(ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage) {
        if (httpMessage instanceof HttpRequest) {
            httpMessage.headers().set((CharSequence)HttpConversionUtil$ExtensionHeaderNames.SCHEME.text(), (Object)Http2StreamFrameToHttpObjectCodec.connectionScheme(channelHandlerContext));
        }
        return HttpConversionUtil.toHttp2Headers(httpMessage, this.validateHeaders);
    }

    private HttpMessage newMessage(int n4, Http2Headers http2Headers) {
        return this.isServer ? HttpConversionUtil.toHttpRequest(n4, http2Headers, this.validateHeaders) : HttpConversionUtil.toHttpResponse(n4, http2Headers, this.validateHeaders);
    }

    private FullHttpMessage newFullMessage(int n4, Http2Headers http2Headers, ByteBufAllocator byteBufAllocator) {
        return this.isServer ? HttpConversionUtil.toFullHttpRequest(n4, http2Headers, byteBufAllocator, this.validateHeaders) : HttpConversionUtil.toFullHttpResponse(n4, http2Headers, byteBufAllocator, this.validateHeaders);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        Attribute<HttpScheme> attribute = Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(channelHandlerContext);
        if (attribute.get() == null) {
            HttpScheme httpScheme = this.isSsl(channelHandlerContext) ? HttpScheme.HTTPS : HttpScheme.HTTP;
            attribute.set(httpScheme);
        }
    }

    protected boolean isSsl(ChannelHandlerContext channelHandlerContext) {
        Channel channel = Http2StreamFrameToHttpObjectCodec.connectionChannel(channelHandlerContext);
        return null != channel.pipeline().get(SslHandler.class);
    }

    private static HttpScheme connectionScheme(ChannelHandlerContext channelHandlerContext) {
        HttpScheme httpScheme = Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(channelHandlerContext).get();
        return httpScheme == null ? HttpScheme.HTTP : httpScheme;
    }

    private static Attribute<HttpScheme> connectionSchemeAttribute(ChannelHandlerContext channelHandlerContext) {
        Channel channel = Http2StreamFrameToHttpObjectCodec.connectionChannel(channelHandlerContext);
        return channel.attr(SCHEME_ATTR_KEY);
    }

    private static Channel connectionChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        return channel instanceof Http2StreamChannel ? channel.parent() : channel;
    }
}

