/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannelBootstrap$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannelBootstrap$2;
import io.grpc.netty.shaded.io.netty.util.AbstractConstant;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Http2StreamChannelBootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrap.class);
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new LinkedHashMap();
    private final Channel channel;
    private volatile ChannelHandler handler;
    private volatile ChannelHandlerContext multiplexCtx;

    public Http2StreamChannelBootstrap(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Http2StreamChannelBootstrap option(ChannelOption<T> channelOption, T t3) {
        if (channelOption == null) {
            throw new NullPointerException("option");
        }
        if (t3 == null) {
            Map<ChannelOption<?>, Object> map = this.options;
            synchronized (map) {
                this.options.remove(channelOption);
            }
        }
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            this.options.put(channelOption, t3);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Http2StreamChannelBootstrap attr(AttributeKey<T> attributeKey, T t3) {
        if (attributeKey == null) {
            throw new NullPointerException("key");
        }
        if (t3 == null) {
            Map<AttributeKey<?>, Object> map = this.attrs;
            synchronized (map) {
                this.attrs.remove(attributeKey);
            }
        }
        Map<AttributeKey<?>, Object> map = this.attrs;
        synchronized (map) {
            this.attrs.put(attributeKey, t3);
        }
        return this;
    }

    public Http2StreamChannelBootstrap handler(ChannelHandler channelHandler) {
        this.handler = ObjectUtil.checkNotNull(channelHandler, "handler");
        return this;
    }

    public Future<Http2StreamChannel> open() {
        return this.open(this.channel.eventLoop().newPromise());
    }

    public Future<Http2StreamChannel> open(Promise<Http2StreamChannel> promise) {
        try {
            ChannelHandlerContext channelHandlerContext = this.findCtx();
            EventExecutor eventExecutor = channelHandlerContext.executor();
            if (eventExecutor.inEventLoop()) {
                this.open0(channelHandlerContext, promise);
            } else {
                ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
                eventExecutor.execute(new Http2StreamChannelBootstrap$1(this, channelHandlerContext2, promise));
            }
        }
        catch (Throwable throwable) {
            promise.setFailure(throwable);
        }
        return promise;
    }

    private ChannelHandlerContext findCtx() {
        ChannelHandlerContext channelHandlerContext = this.multiplexCtx;
        if (channelHandlerContext != null && !channelHandlerContext.isRemoved()) {
            return channelHandlerContext;
        }
        ChannelPipeline channelPipeline = this.channel.pipeline();
        channelHandlerContext = channelPipeline.context(Http2MultiplexCodec.class);
        if (channelHandlerContext == null) {
            channelHandlerContext = channelPipeline.context(Http2MultiplexHandler.class);
        }
        if (channelHandlerContext == null) {
            if (this.channel.isActive()) {
                throw new IllegalStateException(StringUtil.simpleClassName(Http2MultiplexCodec.class) + " or " + StringUtil.simpleClassName(Http2MultiplexHandler.class) + " must be in the ChannelPipeline of Channel " + this.channel);
            }
            throw new ClosedChannelException();
        }
        this.multiplexCtx = channelHandlerContext;
        return channelHandlerContext;
    }

    @Deprecated
    public void open0(ChannelHandlerContext channelHandlerContext, Promise<Http2StreamChannel> promise) {
        assert (channelHandlerContext.executor().inEventLoop());
        Http2StreamChannel http2StreamChannel = channelHandlerContext.handler() instanceof Http2MultiplexCodec ? ((Http2MultiplexCodec)channelHandlerContext.handler()).newOutboundStream() : ((Http2MultiplexHandler)channelHandlerContext.handler()).newOutboundStream();
        try {
            this.init(http2StreamChannel);
        }
        catch (Exception exception) {
            http2StreamChannel.unsafe().closeForcibly();
            promise.setFailure(exception);
            return;
        }
        ChannelFuture channelFuture = channelHandlerContext.channel().eventLoop().register(http2StreamChannel);
        channelFuture.addListener(new Http2StreamChannelBootstrap$2(this, promise, http2StreamChannel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Channel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        ChannelHandler channelHandler = this.handler;
        if (channelHandler != null) {
            channelPipeline.addLast(channelHandler);
        }
        Map<AbstractConstant, Object> map = this.options;
        synchronized (map) {
            Http2StreamChannelBootstrap.setChannelOptions(channel, this.options);
        }
        map = this.attrs;
        synchronized (map) {
            for (Map.Entry<AttributeKey<?>, Object> entry : this.attrs.entrySet()) {
                channel.attr(entry.getKey()).set(entry.getValue());
            }
        }
    }

    private static void setChannelOptions(Channel channel, Map<ChannelOption<?>, Object> map) {
        for (Map.Entry<ChannelOption<?>, Object> entry : map.entrySet()) {
            Http2StreamChannelBootstrap.setChannelOption(channel, entry.getKey(), entry.getValue());
        }
    }

    private static void setChannelOption(Channel channel, ChannelOption<?> channelOption, Object object) {
        try {
            if (!channel.config().setOption(channelOption, object)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", (Object)channelOption, (Object)channel);
            }
        }
        catch (Throwable throwable) {
            logger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", channelOption, object, channel, throwable);
        }
    }
}

