/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameLogger;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameLogger$Direction;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter$Configuration;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class Http2OutboundFrameLogger
implements Http2FrameWriter {
    private final Http2FrameWriter writer;
    private final Http2FrameLogger logger;

    public Http2OutboundFrameLogger(Http2FrameWriter http2FrameWriter, Http2FrameLogger http2FrameLogger) {
        this.writer = ObjectUtil.checkNotNull(http2FrameWriter, "writer");
        this.logger = ObjectUtil.checkNotNull(http2FrameLogger, "logger");
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n4, ByteBuf byteBuf, int n7, boolean bl3, ChannelPromise channelPromise) {
        this.logger.logData(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, byteBuf, n7, bl3);
        return this.writer.writeData(channelHandlerContext, n4, byteBuf, n7, bl3, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, boolean bl3, ChannelPromise channelPromise) {
        this.logger.logHeaders(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, http2Headers, n7, bl3);
        return this.writer.writeHeaders(channelHandlerContext, n4, http2Headers, n7, bl3, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n4, Http2Headers http2Headers, int n7, short s11, boolean bl3, int n8, boolean bl4, ChannelPromise channelPromise) {
        this.logger.logHeaders(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4);
        return this.writer.writeHeaders(channelHandlerContext, n4, http2Headers, n7, s11, bl3, n8, bl4, channelPromise);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n4, int n7, short s11, boolean bl3, ChannelPromise channelPromise) {
        this.logger.logPriority(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, n7, s11, bl3);
        return this.writer.writePriority(channelHandlerContext, n4, n7, s11, bl3, channelPromise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n4, long l2, ChannelPromise channelPromise) {
        this.logger.logRstStream(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, l2);
        return this.writer.writeRstStream(channelHandlerContext, n4, l2, channelPromise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        this.logger.logSettings(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, http2Settings);
        return this.writer.writeSettings(channelHandlerContext, http2Settings, channelPromise);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.logger.logSettingsAck(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext);
        return this.writer.writeSettingsAck(channelHandlerContext, channelPromise);
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl3, long l2, ChannelPromise channelPromise) {
        if (bl3) {
            this.logger.logPingAck(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, l2);
        } else {
            this.logger.logPing(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, l2);
        }
        return this.writer.writePing(channelHandlerContext, bl3, l2, channelPromise);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n4, int n7, Http2Headers http2Headers, int n8, ChannelPromise channelPromise) {
        this.logger.logPushPromise(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, n7, http2Headers, n8);
        return this.writer.writePushPromise(channelHandlerContext, n4, n7, http2Headers, n8, channelPromise);
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n4, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.logger.logGoAway(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, l2, byteBuf);
        return this.writer.writeGoAway(channelHandlerContext, n4, l2, byteBuf, channelPromise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n4, int n7, ChannelPromise channelPromise) {
        this.logger.logWindowsUpdate(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n4, n7);
        return this.writer.writeWindowUpdate(channelHandlerContext, n4, n7, channelPromise);
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by2, int n4, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.logger.logUnknownFrame(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, by2, n4, http2Flags, byteBuf);
        return this.writer.writeFrame(channelHandlerContext, by2, n4, http2Flags, byteBuf, channelPromise);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public Http2FrameWriter$Configuration configuration() {
        return this.writer.configuration();
    }
}

