/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ServerChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$DefaultHttp2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStreamEvent$Type;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStreamException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexHandler$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexHandler$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexHandler$Http2MultiplexHandlerStreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ResetFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.MaxCapacityQueue;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public final class Http2MultiplexHandler
extends Http2ChannelDuplexHandler {
    static final ChannelFutureListener CHILD_CHANNEL_REGISTRATION_LISTENER = new Http2MultiplexHandler$1();
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    private volatile ChannelHandlerContext ctx;

    public Http2MultiplexHandler(ChannelHandler channelHandler) {
        this(channelHandler, null);
    }

    public Http2MultiplexHandler(ChannelHandler channelHandler, ChannelHandler channelHandler2) {
        this.inboundStreamHandler = ObjectUtil.checkNotNull(channelHandler, "inboundStreamHandler");
        this.upgradeStreamHandler = channelHandler2;
    }

    static void registerDone(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            Channel channel = channelFuture.channel();
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
    }

    @Override
    protected void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.readCompletePendingQueue.clear();
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.parentReadInProgress = true;
        if (object instanceof Http2StreamFrame) {
            if (object instanceof Http2WindowUpdateFrame) {
                return;
            }
            Http2StreamFrame http2StreamFrame = (Http2StreamFrame)object;
            Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream = (Http2FrameCodec$DefaultHttp2FrameStream)http2StreamFrame.stream();
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)http2FrameCodec$DefaultHttp2FrameStream.attachment;
            if (object instanceof Http2ResetFrame) {
                abstractHttp2StreamChannel.pipeline().fireUserEventTriggered(object);
            } else {
                abstractHttp2StreamChannel.fireChildRead(http2StreamFrame);
            }
            return;
        }
        if (object instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)object);
        }
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof Http2FrameStreamEvent) {
            Http2FrameStreamEvent http2FrameStreamEvent = (Http2FrameStreamEvent)object;
            Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream = (Http2FrameCodec$DefaultHttp2FrameStream)http2FrameStreamEvent.stream();
            if (http2FrameStreamEvent.type() == Http2FrameStreamEvent$Type.State) {
                switch (http2FrameCodec$DefaultHttp2FrameStream.state()) {
                    case HALF_CLOSED_LOCAL: {
                        if (http2FrameCodec$DefaultHttp2FrameStream.id() != 1) break;
                    }
                    case HALF_CLOSED_REMOTE: 
                    case OPEN: {
                        Http2MultiplexHandler$Http2MultiplexHandlerStreamChannel http2MultiplexHandler$Http2MultiplexHandlerStreamChannel;
                        if (http2FrameCodec$DefaultHttp2FrameStream.attachment != null) break;
                        if (http2FrameCodec$DefaultHttp2FrameStream.id() == 1 && !Http2MultiplexHandler.isServer(channelHandlerContext)) {
                            if (this.upgradeStreamHandler == null) {
                                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
                            }
                            http2MultiplexHandler$Http2MultiplexHandlerStreamChannel = new Http2MultiplexHandler$Http2MultiplexHandlerStreamChannel(this, http2FrameCodec$DefaultHttp2FrameStream, this.upgradeStreamHandler);
                            http2MultiplexHandler$Http2MultiplexHandlerStreamChannel.closeOutbound();
                        } else {
                            http2MultiplexHandler$Http2MultiplexHandlerStreamChannel = new Http2MultiplexHandler$Http2MultiplexHandlerStreamChannel(this, http2FrameCodec$DefaultHttp2FrameStream, this.inboundStreamHandler);
                        }
                        ChannelFuture channelFuture = channelHandlerContext.channel().eventLoop().register(http2MultiplexHandler$Http2MultiplexHandlerStreamChannel);
                        if (channelFuture.isDone()) {
                            Http2MultiplexHandler.registerDone(channelFuture);
                            break;
                        }
                        channelFuture.addListener(CHILD_CHANNEL_REGISTRATION_LISTENER);
                        break;
                    }
                    case CLOSED: {
                        AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)http2FrameCodec$DefaultHttp2FrameStream.attachment;
                        if (abstractHttp2StreamChannel == null) break;
                        abstractHttp2StreamChannel.streamClosed();
                        break;
                    }
                }
            }
            return;
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    Http2StreamChannel newOutboundStream() {
        return new Http2MultiplexHandler$Http2MultiplexHandlerStreamChannel(this, (Http2FrameCodec$DefaultHttp2FrameStream)this.newStream(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof Http2FrameStreamException) {
            Http2FrameStreamException http2FrameStreamException = (Http2FrameStreamException)throwable;
            Http2FrameStream http2FrameStream = http2FrameStreamException.stream();
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec$DefaultHttp2FrameStream)http2FrameStream).attachment;
            try {
                abstractHttp2StreamChannel.pipeline().fireExceptionCaught(throwable.getCause());
            }
            finally {
                abstractHttp2StreamChannel.unsafe().closeForcibly();
            }
            return;
        }
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    private static boolean isServer(ChannelHandlerContext channelHandlerContext) {
        return channelHandlerContext.channel().parent() instanceof ServerChannel;
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame) {
        try {
            boolean bl3 = Http2MultiplexHandler.isServer(channelHandlerContext);
            this.forEachActiveStream(new Http2MultiplexHandler$2(this, http2GoAwayFrame, bl3));
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught(http2Exception);
            channelHandlerContext.close();
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.processPendingReadCompleteQueue();
        channelHandlerContext.fireChannelReadComplete();
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = this.readCompletePendingQueue.poll();
        if (abstractHttp2StreamChannel != null) {
            try {
                do {
                    abstractHttp2StreamChannel.fireChildReadComplete();
                } while ((abstractHttp2StreamChannel = this.readCompletePendingQueue.poll()) != null);
            }
            finally {
                this.parentReadInProgress = false;
                this.readCompletePendingQueue.clear();
                this.ctx.flush();
            }
        } else {
            this.parentReadInProgress = false;
        }
    }

    static /* synthetic */ int access$004(Http2MultiplexHandler http2MultiplexHandler) {
        return ++http2MultiplexHandler.idCount;
    }

    static /* synthetic */ boolean access$100(Http2MultiplexHandler http2MultiplexHandler) {
        return http2MultiplexHandler.parentReadInProgress;
    }

    static /* synthetic */ Queue access$200(Http2MultiplexHandler http2MultiplexHandler) {
        return http2MultiplexHandler.readCompletePendingQueue;
    }

    static /* synthetic */ void access$300(Http2MultiplexHandler http2MultiplexHandler) {
        http2MultiplexHandler.processPendingReadCompleteQueue();
    }

    static /* synthetic */ ChannelHandlerContext access$400(Http2MultiplexHandler http2MultiplexHandler) {
        return http2MultiplexHandler.ctx;
    }
}

