/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http2;

import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Frame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameCodec$DefaultHttp2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameStreamException;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexCodec$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexCodec$Http2MultiplexCodecStreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2StreamFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.MaxCapacityQueue;
import java.util.ArrayDeque;
import java.util.Queue;

@Deprecated
public class Http2MultiplexCodec
extends Http2FrameCodec {
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    volatile ChannelHandlerContext ctx;

    Http2MultiplexCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings, ChannelHandler channelHandler, ChannelHandler channelHandler2, boolean bl3) {
        super(http2ConnectionEncoder, http2ConnectionDecoder, http2Settings, bl3);
        this.inboundStreamHandler = channelHandler;
        this.upgradeStreamHandler = channelHandler2;
    }

    @Override
    public void onHttpClientUpgrade() {
        if (this.upgradeStreamHandler == null) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
        }
        super.onHttpClientUpgrade();
    }

    @Override
    public final void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    @Override
    public final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved0(channelHandlerContext);
        this.readCompletePendingQueue.clear();
    }

    @Override
    final void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        if (http2Frame instanceof Http2StreamFrame) {
            Http2StreamFrame http2StreamFrame = (Http2StreamFrame)http2Frame;
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec$DefaultHttp2FrameStream)http2StreamFrame.stream()).attachment;
            abstractHttp2StreamChannel.fireChildRead(http2StreamFrame);
            return;
        }
        if (http2Frame instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)http2Frame);
        }
        channelHandlerContext.fireChannelRead(http2Frame);
    }

    @Override
    final void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream) {
        switch (http2FrameCodec$DefaultHttp2FrameStream.state()) {
            case HALF_CLOSED_LOCAL: {
                if (http2FrameCodec$DefaultHttp2FrameStream.id() != 1) break;
            }
            case HALF_CLOSED_REMOTE: 
            case OPEN: {
                Http2MultiplexCodec$Http2MultiplexCodecStreamChannel http2MultiplexCodec$Http2MultiplexCodecStreamChannel;
                if (http2FrameCodec$DefaultHttp2FrameStream.attachment != null) break;
                if (http2FrameCodec$DefaultHttp2FrameStream.id() == 1 && !this.connection().isServer()) {
                    assert (this.upgradeStreamHandler != null);
                    http2MultiplexCodec$Http2MultiplexCodecStreamChannel = new Http2MultiplexCodec$Http2MultiplexCodecStreamChannel(this, http2FrameCodec$DefaultHttp2FrameStream, this.upgradeStreamHandler);
                    http2MultiplexCodec$Http2MultiplexCodecStreamChannel.closeOutbound();
                } else {
                    http2MultiplexCodec$Http2MultiplexCodecStreamChannel = new Http2MultiplexCodec$Http2MultiplexCodecStreamChannel(this, http2FrameCodec$DefaultHttp2FrameStream, this.inboundStreamHandler);
                }
                ChannelFuture channelFuture = channelHandlerContext.channel().eventLoop().register(http2MultiplexCodec$Http2MultiplexCodecStreamChannel);
                if (channelFuture.isDone()) {
                    Http2MultiplexHandler.registerDone(channelFuture);
                    break;
                }
                channelFuture.addListener(Http2MultiplexHandler.CHILD_CHANNEL_REGISTRATION_LISTENER);
                break;
            }
            case CLOSED: {
                AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)http2FrameCodec$DefaultHttp2FrameStream.attachment;
                if (abstractHttp2StreamChannel == null) break;
                abstractHttp2StreamChannel.streamClosed();
                break;
            }
        }
    }

    final Http2StreamChannel newOutboundStream() {
        return new Http2MultiplexCodec$Http2MultiplexCodecStreamChannel(this, this.newStream(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        Http2FrameStream http2FrameStream = http2FrameStreamException.stream();
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec$DefaultHttp2FrameStream)http2FrameStream).attachment;
        try {
            abstractHttp2StreamChannel.pipeline().fireExceptionCaught(http2FrameStreamException.getCause());
        }
        finally {
            abstractHttp2StreamChannel.unsafe().closeForcibly();
        }
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame) {
        try {
            this.forEachActiveStream(new Http2MultiplexCodec$1(this, http2GoAwayFrame));
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught(http2Exception);
            channelHandlerContext.close();
        }
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.processPendingReadCompleteQueue();
        this.channelReadComplete0(channelHandlerContext);
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        try {
            AbstractHttp2StreamChannel abstractHttp2StreamChannel;
            while ((abstractHttp2StreamChannel = this.readCompletePendingQueue.poll()) != null) {
                abstractHttp2StreamChannel.fireChildReadComplete();
            }
        }
        finally {
            this.parentReadInProgress = false;
            this.readCompletePendingQueue.clear();
            this.flush0(this.ctx);
        }
    }

    @Override
    public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.parentReadInProgress = true;
        super.channelRead(channelHandlerContext, object);
    }

    @Override
    public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    final void flush0(ChannelHandlerContext channelHandlerContext) {
        this.flush(channelHandlerContext);
    }

    static /* synthetic */ int access$004(Http2MultiplexCodec http2MultiplexCodec) {
        return ++http2MultiplexCodec.idCount;
    }

    static /* synthetic */ boolean access$100(Http2MultiplexCodec http2MultiplexCodec) {
        return http2MultiplexCodec.parentReadInProgress;
    }

    static /* synthetic */ Queue access$200(Http2MultiplexCodec http2MultiplexCodec) {
        return http2MultiplexCodec.readCompletePendingQueue;
    }

    static /* synthetic */ void access$300(Http2MultiplexCodec http2MultiplexCodec) {
        http2MultiplexCodec.processPendingReadCompleteQueue();
    }
}

